/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.python.semantic.v2.SymbolV2;
import org.sonar.python.tree.PyTree;
import org.sonar.python.types.InferredTypes;

public class NameImpl
extends PyTree
implements Name {
    private final Token token;
    private final String name;
    private final boolean isVariable;
    private Symbol symbol;
    private Usage usage;
    private InferredType inferredType = InferredTypes.anyType();
    private PythonType pythonType = PythonType.UNKNOWN;
    private static final String TRUE = "True";
    private static final String FALSE = "False";
    private SymbolV2 symbolV2;

    public NameImpl(Token token, boolean isVariable) {
        this.token = token;
        this.name = token.value();
        this.isVariable = isVariable;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean isVariable() {
        boolean isKeyword = false;
        if (this.parent() != null && this.parent().is(Tree.Kind.REGULAR_ARGUMENT)) {
            isKeyword = ((RegularArgument)this.parent()).keywordArgument() == this;
        }
        return this.isVariable && !isKeyword;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.NAME;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitName(this);
    }

    @Override
    public List<Tree> computeChildren() {
        return Collections.singletonList(this.token);
    }

    @Override
    @CheckForNull
    public Symbol symbol() {
        return this.symbol;
    }

    @Override
    @CheckForNull
    public Usage usage() {
        return this.usage;
    }

    public void setSymbol(Symbol symbol) {
        this.symbol = symbol;
    }

    public void setUsage(Usage usage) {
        this.usage = usage;
    }

    @Override
    public InferredType type() {
        if (this.symbol != null) {
            if (this.isBooleanBuiltinSymbol()) {
                return InferredTypes.BOOL;
            }
            if (this.symbol.kind() == Symbol.Kind.CLASS) {
                return InferredTypes.TYPE;
            }
        }
        return this.inferredType;
    }

    private boolean isBooleanBuiltinSymbol() {
        return TRUE.equals(this.symbol.name()) && TRUE.equals(this.symbol.fullyQualifiedName()) || FALSE.equals(this.symbol.name()) && FALSE.equals(this.symbol.fullyQualifiedName());
    }

    public void setInferredType(InferredType inferredType) {
        this.inferredType = inferredType;
    }

    @Override
    public PythonType typeV2() {
        return this.pythonType;
    }

    public NameImpl typeV2(PythonType pythonType) {
        this.pythonType = pythonType;
        return this;
    }

    @Override
    public SymbolV2 symbolV2() {
        return this.symbolV2;
    }

    public void symbolV2(SymbolV2 symbolV2) {
        this.symbolV2 = symbolV2;
    }
}

