/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.KeyValuePair;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class KeyValuePairImpl
extends PyTree
implements KeyValuePair {
    private final Expression key;
    private final Token colon;
    private final Expression value;

    public KeyValuePairImpl(Expression key, Token colon, Expression value) {
        this.key = key;
        this.colon = colon;
        this.value = value;
    }

    @Override
    @CheckForNull
    public Expression key() {
        return this.key;
    }

    @Override
    @CheckForNull
    public Token colon() {
        return this.colon;
    }

    @Override
    @CheckForNull
    public Expression value() {
        return this.value;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitKeyValuePair(this);
    }

    @Override
    public List<Tree> computeChildren() {
        return Arrays.asList(this.key, this.colon, this.value);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.KEY_VALUE_PAIR;
    }
}

