/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FormatSpecifier;
import org.sonar.plugins.python.api.tree.FormattedExpression;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class FormattedExpressionImpl
extends PyTree
implements FormattedExpression {
    private final Expression expression;
    private final Token equalToken;
    private final FormatSpecifier formatSpecifier;
    private final Token lCurlyBrace;
    private final Token rCurlyBrace;
    private final Token fstringConversionToken;
    private final Token fstringConversionName;

    public FormattedExpressionImpl(Expression expression, @Nullable Token lCurlyBrace, @Nullable Token rCurlyBrace, @Nullable Token equalToken, @Nullable FormatSpecifier formatSpecifier, @Nullable Token fstringConversionToken, @Nullable Token fstringConversionName) {
        this.expression = expression;
        this.equalToken = equalToken;
        this.formatSpecifier = formatSpecifier;
        this.lCurlyBrace = lCurlyBrace;
        this.rCurlyBrace = rCurlyBrace;
        this.fstringConversionToken = fstringConversionToken;
        this.fstringConversionName = fstringConversionName;
    }

    @Override
    public Expression expression() {
        return this.expression;
    }

    @Override
    public Token equalToken() {
        return this.equalToken;
    }

    @Override
    public FormatSpecifier formatSpecifier() {
        return this.formatSpecifier;
    }

    @Override
    List<Tree> computeChildren() {
        return Stream.of(this.lCurlyBrace, this.expression, this.equalToken, this.fstringConversionToken, this.fstringConversionName, this.formatSpecifier, this.rCurlyBrace).filter(Objects::nonNull).toList();
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitFormattedExpression(this);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.FORMATTED_EXPRESSION;
    }
}

