/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.tree.FinallyClause;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class FinallyClauseImpl
extends PyTree
implements FinallyClause {
    private final Token finallyKeyword;
    private final Token colon;
    private final Token newLine;
    private final Token indent;
    private final StatementList body;
    private final Token dedent;

    public FinallyClauseImpl(Token finallyKeyword, Token colon, @Nullable Token newLine, @Nullable Token indent, StatementList body, @Nullable Token dedent) {
        this.finallyKeyword = finallyKeyword;
        this.colon = colon;
        this.newLine = newLine;
        this.indent = indent;
        this.body = body;
        this.dedent = dedent;
    }

    @Override
    public Token finallyKeyword() {
        return this.finallyKeyword;
    }

    @Override
    public StatementList body() {
        return this.body;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.FINALLY_CLAUSE;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitFinallyClause(this);
    }

    @Override
    public List<Tree> computeChildren() {
        return Stream.of(this.finallyKeyword, this.colon, this.newLine, this.indent, this.body, this.dedent).filter(Objects::nonNull).toList();
    }
}

