/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.BreakStatement;
import org.sonar.plugins.python.api.tree.ContinueStatement;
import org.sonar.plugins.python.api.tree.ReturnStatement;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.tree.PythonTreeMakerUtils;
import org.sonar.python.tree.TreeUtils;

public class ExceptGroupJumpInstructionsCheck
extends BaseTreeVisitor {
    @Override
    public void visitBreakStatement(BreakStatement breakStatement) {
        ExceptGroupJumpInstructionsCheck.checkExceptGroupStatement(breakStatement, "break statement cannot appear in except* block", Tree.Kind.EXCEPT_GROUP_CLAUSE, Tree.Kind.FOR_STMT, Tree.Kind.WHILE_STMT);
    }

    @Override
    public void visitContinueStatement(ContinueStatement continueStatement) {
        ExceptGroupJumpInstructionsCheck.checkExceptGroupStatement(continueStatement, "continue statement cannot appear in except* block", Tree.Kind.EXCEPT_GROUP_CLAUSE, Tree.Kind.FOR_STMT, Tree.Kind.WHILE_STMT);
    }

    @Override
    public void visitReturnStatement(ReturnStatement returnStatement) {
        ExceptGroupJumpInstructionsCheck.checkExceptGroupStatement(returnStatement, "return statement cannot appear in except* block", Tree.Kind.EXCEPT_GROUP_CLAUSE, Tree.Kind.FUNCDEF);
    }

    private static void checkExceptGroupStatement(Tree statement, String message, Tree.Kind ... possibleParents) {
        Tree parent = TreeUtils.firstAncestorOfKind(statement, possibleParents);
        if (parent != null && parent.is(Tree.Kind.EXCEPT_GROUP_CLAUSE)) {
            PythonTreeMakerUtils.throwRecognitionException(statement.firstToken().line(), message);
        }
    }
}

