/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.tree.ExceptClause;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class ExceptClauseImpl
extends PyTree
implements ExceptClause {
    private final Token exceptKeyword;
    private final Token starToken;
    private final Token colon;
    private final Token newLine;
    private final Token indent;
    private final StatementList body;
    private final Token dedent;
    private final Expression exception;
    private final Token asKeyword;
    private final Token commaToken;
    private final Expression exceptionInstance;

    public ExceptClauseImpl(Token exceptKeyword, @Nullable Token starToken, Token colon, @Nullable Token newLine, @Nullable Token indent, StatementList body, @Nullable Token dedent) {
        this.exceptKeyword = exceptKeyword;
        this.starToken = starToken;
        this.colon = colon;
        this.newLine = newLine;
        this.indent = indent;
        this.body = body;
        this.dedent = dedent;
        this.exception = null;
        this.asKeyword = null;
        this.commaToken = null;
        this.exceptionInstance = null;
    }

    public ExceptClauseImpl(Token exceptKeyword, @Nullable Token starToken, Token colon, @Nullable Token newLine, @Nullable Token indent, StatementList body, @Nullable Token dedent, Expression exception, @Nullable Token asNode, @Nullable Token commaNode, Expression exceptionInstance) {
        this.exceptKeyword = exceptKeyword;
        this.starToken = starToken;
        this.colon = colon;
        this.newLine = newLine;
        this.indent = indent;
        this.body = body;
        this.dedent = dedent;
        this.exception = exception;
        this.asKeyword = asNode;
        this.commaToken = commaNode;
        this.exceptionInstance = exceptionInstance;
    }

    public ExceptClauseImpl(Token exceptKeyword, @Nullable Token starToken, Token colon, @Nullable Token newLine, @Nullable Token indent, StatementList body, @Nullable Token dedent, Expression exception) {
        this.exceptKeyword = exceptKeyword;
        this.starToken = starToken;
        this.colon = colon;
        this.newLine = newLine;
        this.indent = indent;
        this.body = body;
        this.dedent = dedent;
        this.exception = exception;
        this.asKeyword = null;
        this.commaToken = null;
        this.exceptionInstance = null;
    }

    @Override
    public Token exceptKeyword() {
        return this.exceptKeyword;
    }

    @Override
    @CheckForNull
    public Token starToken() {
        return this.starToken;
    }

    @Override
    public StatementList body() {
        return this.body;
    }

    @Override
    @CheckForNull
    public Token asKeyword() {
        return this.asKeyword;
    }

    @Override
    @CheckForNull
    @Deprecated(since="5.12")
    public Token commaToken() {
        return this.commaToken;
    }

    @Override
    @CheckForNull
    public Expression exception() {
        return this.exception;
    }

    @Override
    @CheckForNull
    public Expression exceptionInstance() {
        return this.exceptionInstance;
    }

    @Override
    public Token colon() {
        return this.colon;
    }

    @Override
    public Tree.Kind getKind() {
        return this.starToken != null ? Tree.Kind.EXCEPT_GROUP_CLAUSE : Tree.Kind.EXCEPT_CLAUSE;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitExceptClause(this);
    }

    @Override
    public List<Tree> computeChildren() {
        return Stream.of(this.exceptKeyword, this.starToken, this.exception, this.asKeyword, this.commaToken, this.exceptionInstance, this.colon, this.newLine, this.indent, this.body, this.dedent).filter(Objects::nonNull).toList();
    }
}

