/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.tree.ElseClause;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class ElseClauseImpl
extends PyTree
implements ElseClause {
    private final Token elseKeyword;
    private final Token colon;
    private final Token newLine;
    private final Token indent;
    private final StatementList body;
    private final Token dedent;

    public ElseClauseImpl(Token elseKeyword, Token colon, @Nullable Token newLine, @Nullable Token indent, StatementList body, @Nullable Token dedent) {
        this.elseKeyword = elseKeyword;
        this.colon = colon;
        this.newLine = newLine;
        this.indent = indent;
        this.body = body;
        this.dedent = dedent;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.ELSE_CLAUSE;
    }

    @Override
    public Token elseKeyword() {
        return this.elseKeyword;
    }

    @Override
    public StatementList body() {
        return this.body;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitElseClause(this);
    }

    @Override
    public List<Tree> computeChildren() {
        return Stream.of(this.elseKeyword, this.colon, this.newLine, this.indent, this.body, this.dedent).filter(Objects::nonNull).toList();
    }
}

