/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.sonar.plugins.python.api.tree.ConditionalExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.tree.PyTree;
import org.sonar.python.types.HasTypeDependencies;
import org.sonar.python.types.InferredTypes;

public class ConditionalExpressionImpl
extends PyTree
implements ConditionalExpression,
HasTypeDependencies {
    private final Expression trueExpression;
    private final Token ifToken;
    private final Expression condition;
    private final Token elseToken;
    private final Expression falseExpression;

    public ConditionalExpressionImpl(Expression trueExpression, Token ifToken, Expression condition, Token elseToken, Expression falseExpression) {
        this.trueExpression = trueExpression;
        this.ifToken = ifToken;
        this.condition = condition;
        this.elseToken = elseToken;
        this.falseExpression = falseExpression;
    }

    @Override
    public Token ifKeyword() {
        return this.ifToken;
    }

    @Override
    public Token elseKeyword() {
        return this.elseToken;
    }

    @Override
    public Expression trueExpression() {
        return this.trueExpression;
    }

    @Override
    public Expression falseExpression() {
        return this.falseExpression;
    }

    @Override
    public Expression condition() {
        return this.condition;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitConditionalExpression(this);
    }

    @Override
    public List<Tree> computeChildren() {
        return Stream.of(this.trueExpression, this.ifToken, this.condition, this.elseToken, this.falseExpression).filter(Objects::nonNull).toList();
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.CONDITIONAL_EXPR;
    }

    @Override
    public InferredType type() {
        return InferredTypes.or(this.trueExpression.type(), this.falseExpression.type());
    }

    @Override
    public List<Expression> typeDependencies() {
        return Arrays.asList(this.trueExpression, this.falseExpression);
    }
}

