/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.tree.ComprehensionClause;
import org.sonar.plugins.python.api.tree.ComprehensionIf;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class ComprehensionIfImpl
extends PyTree
implements ComprehensionIf {
    private final Token ifToken;
    private final Expression condition;
    private final ComprehensionClause nestedClause;

    public ComprehensionIfImpl(Token ifToken, Expression condition, @Nullable ComprehensionClause nestedClause) {
        this.ifToken = ifToken;
        this.condition = condition;
        this.nestedClause = nestedClause;
    }

    @Override
    public Token ifToken() {
        return this.ifToken;
    }

    @Override
    public Expression condition() {
        return this.condition;
    }

    @Override
    @CheckForNull
    public ComprehensionClause nestedClause() {
        return this.nestedClause;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitComprehensionIf(this);
    }

    @Override
    public List<Tree> computeChildren() {
        return Stream.of(this.ifToken, this.condition, this.nestedClause).filter(Objects::nonNull).toList();
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.COMP_IF;
    }
}

