/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.ArgList;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.Decorator;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.plugins.python.api.tree.TypeParams;
import org.sonar.python.tree.PyTree;

public class ClassDefImpl
extends PyTree
implements ClassDef {
    private final List<Decorator> decorators;
    private final Token classKeyword;
    private final Name name;
    private final TypeParams typeParams;
    private final Token leftPar;
    private final ArgList args;
    private final Token rightPar;
    private final Token colon;
    private final Token newLine;
    private final Token indent;
    private final Token dedent;
    private final StatementList body;
    private final StringLiteral docstring;
    private final Set<Symbol> classFields = new HashSet<Symbol>();
    private final Set<Symbol> instanceFields = new HashSet<Symbol>();

    public ClassDefImpl(List<Decorator> decorators, Token classKeyword, Name name, @Nullable TypeParams typeParams, @Nullable Token leftPar, @Nullable ArgList args, @Nullable Token rightPar, Token colon, @Nullable Token newLine, @Nullable Token indent, StatementList body, @Nullable Token dedent, StringLiteral docstring) {
        this.decorators = decorators;
        this.classKeyword = classKeyword;
        this.name = name;
        this.typeParams = typeParams;
        this.leftPar = leftPar;
        this.args = args;
        this.rightPar = rightPar;
        this.colon = colon;
        this.newLine = newLine;
        this.indent = indent;
        this.docstring = docstring;
        this.body = body;
        this.dedent = dedent;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.CLASSDEF;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitClassDef(this);
    }

    @Override
    public List<Decorator> decorators() {
        return this.decorators;
    }

    @Override
    public Token classKeyword() {
        return this.classKeyword;
    }

    @Override
    public Name name() {
        return this.name;
    }

    @Override
    @CheckForNull
    public TypeParams typeParams() {
        return this.typeParams;
    }

    @Override
    @CheckForNull
    public Token leftPar() {
        return this.leftPar;
    }

    @Override
    @CheckForNull
    public ArgList args() {
        return this.args;
    }

    @Override
    @CheckForNull
    public Token rightPar() {
        return this.rightPar;
    }

    @Override
    public Token colon() {
        return this.colon;
    }

    @Override
    public StatementList body() {
        return this.body;
    }

    @Override
    @CheckForNull
    public StringLiteral docstring() {
        return this.docstring;
    }

    @Override
    public Set<Symbol> classFields() {
        return this.classFields;
    }

    @Override
    public Set<Symbol> instanceFields() {
        return this.instanceFields;
    }

    public void addClassField(Symbol field) {
        this.classFields.add(field);
    }

    public void addInstanceField(Symbol field) {
        this.instanceFields.add(field);
    }

    @Override
    public List<Tree> computeChildren() {
        return Stream.of(this.decorators, Arrays.asList(this.classKeyword, this.name, this.typeParams, this.leftPar, this.args, this.rightPar, this.colon, this.newLine, this.indent, this.body, this.dedent)).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

