/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.symbols.AmbiguousSymbol;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.ArgList;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.SubscriptionExpression;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.plugins.python.api.types.v2.ClassType;
import org.sonar.plugins.python.api.types.v2.FunctionType;
import org.sonar.plugins.python.api.types.v2.ObjectType;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.plugins.python.api.types.v2.TypeOrigin;
import org.sonar.plugins.python.api.types.v2.TypeSource;
import org.sonar.plugins.python.api.types.v2.UnionType;
import org.sonar.plugins.python.api.types.v2.UnknownType;
import org.sonar.python.semantic.ClassSymbolImpl;
import org.sonar.python.semantic.FunctionSymbolImpl;
import org.sonar.python.semantic.v2.ObjectTypeBuilder;
import org.sonar.python.tree.PyTree;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.DeclaredType;
import org.sonar.python.types.HasTypeDependencies;
import org.sonar.python.types.InferredTypes;

public class CallExpressionImpl
extends PyTree
implements CallExpression,
HasTypeDependencies {
    private final Expression callee;
    private final ArgList argumentList;
    private final Token leftPar;
    private final Token rightPar;

    public CallExpressionImpl(Expression callee, @Nullable ArgList argumentList, Token leftPar, Token rightPar) {
        this.callee = callee;
        this.argumentList = argumentList;
        this.leftPar = leftPar;
        this.rightPar = rightPar;
    }

    @Override
    public Expression callee() {
        return this.callee;
    }

    @Override
    public ArgList argumentList() {
        return this.argumentList;
    }

    @Override
    public List<Argument> arguments() {
        return this.argumentList != null ? this.argumentList.arguments() : Collections.emptyList();
    }

    @Override
    public Token leftPar() {
        return this.leftPar;
    }

    @Override
    public Token rightPar() {
        return this.rightPar;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.CALL_EXPR;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitCallExpression(this);
    }

    @Override
    public List<Tree> computeChildren() {
        return Stream.of(this.callee, this.leftPar, this.argumentList, this.rightPar).filter(Objects::nonNull).toList();
    }

    @Override
    public InferredType type() {
        Symbol calleeSymbol = this.calleeSymbol();
        if (calleeSymbol != null) {
            InferredType type = CallExpressionImpl.getType(calleeSymbol);
            if (type.equals(InferredTypes.anyType()) && this.callee.is(Tree.Kind.QUALIFIED_EXPR)) {
                return CallExpressionImpl.getDeclaredType(this.callee);
            }
            return type;
        }
        if (this.callee.is(Tree.Kind.SUBSCRIPTION)) {
            return TreeUtils.getSymbolFromTree(((SubscriptionExpression)this.callee).object()).filter(CallExpressionImpl::supportsGenerics).map(InferredTypes::runtimeType).orElse(InferredTypes.anyType());
        }
        return InferredTypes.anyType();
    }

    private static boolean supportsGenerics(Symbol symbol) {
        switch (symbol.kind()) {
            case CLASS: {
                return ((ClassSymbolImpl)symbol).supportsGenerics();
            }
            case AMBIGUOUS: {
                return ((AmbiguousSymbol)symbol).alternatives().stream().allMatch(CallExpressionImpl::supportsGenerics);
            }
        }
        return false;
    }

    private static InferredType getDeclaredType(Expression callee) {
        QualifiedExpression qualifiedCallee = (QualifiedExpression)callee;
        InferredType qualifierType = qualifiedCallee.qualifier().type();
        if (qualifierType instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)qualifierType;
            Set resolvedMembers = declaredType.alternativeTypeSymbols().stream().filter(s -> s.is(Symbol.Kind.CLASS)).map(ClassSymbol.class::cast).map(t -> t.resolveMember(qualifiedCallee.name().name())).filter(Optional::isPresent).collect(Collectors.toSet());
            if (resolvedMembers.size() == 1) {
                return ((Optional)resolvedMembers.iterator().next()).map(CallExpressionImpl::getType).map(DeclaredType::fromInferredType).orElse(InferredTypes.anyType());
            }
        }
        return InferredTypes.anyType();
    }

    private static InferredType getType(Symbol symbol) {
        if (symbol.is(Symbol.Kind.CLASS)) {
            ClassSymbol classSymbol = (ClassSymbol)symbol;
            if ("typing.NamedTuple".equals(classSymbol.fullyQualifiedName())) {
                return InferredTypes.TYPE;
            }
            return InferredTypes.runtimeType(classSymbol);
        }
        if (symbol.is(Symbol.Kind.FUNCTION)) {
            FunctionSymbolImpl functionSymbol = (FunctionSymbolImpl)symbol;
            return functionSymbol.declaredReturnType();
        }
        if (symbol.is(Symbol.Kind.AMBIGUOUS)) {
            Set<Symbol> alternatives = ((AmbiguousSymbol)symbol).alternatives();
            return InferredTypes.union(alternatives.stream().map(CallExpressionImpl::getType));
        }
        return InferredTypes.anyOrUnknownClassType(symbol);
    }

    @Override
    public List<Expression> typeDependencies() {
        return Collections.singletonList(this.callee);
    }

    @Override
    public PythonType typeV2() {
        PythonType calleeType = this.callee().typeV2();
        TypeSource typeSource = this.computeTypeSource(calleeType);
        PythonType pythonType = CallExpressionImpl.returnTypeOfCall(calleeType);
        if (pythonType instanceof ObjectType) {
            ObjectType objectType = (ObjectType)pythonType;
            return ObjectTypeBuilder.fromObjectType(objectType).withTypeSource(typeSource).build();
        }
        return pythonType;
    }

    private TypeSource computeTypeSource(PythonType calleeType) {
        if (this.isCalleeLocallyDefinedFunction(calleeType)) {
            return TypeSource.TYPE_HINT;
        }
        return this.calleeTypeSource();
    }

    boolean isCalleeLocallyDefinedFunction(PythonType pythonType) {
        if (pythonType instanceof FunctionType) {
            FunctionType functionType = (FunctionType)pythonType;
            return functionType.typeOrigin() == TypeOrigin.LOCAL;
        }
        if (pythonType instanceof UnionType) {
            UnionType unionType = (UnionType)pythonType;
            return unionType.candidates().stream().anyMatch(this::isCalleeLocallyDefinedFunction);
        }
        return false;
    }

    static PythonType returnTypeOfCall(PythonType calleeType) {
        if (calleeType instanceof ClassType) {
            ClassType classType = (ClassType)calleeType;
            return new ObjectType(classType);
        }
        if (calleeType instanceof FunctionType) {
            FunctionType functionType = (FunctionType)calleeType;
            return functionType.returnType();
        }
        if (calleeType instanceof UnionType) {
            UnionType unionType = (UnionType)calleeType;
            HashSet<PythonType> types = new HashSet<PythonType>();
            for (PythonType candidate : unionType.candidates()) {
                PythonType typeOfCandidate = CallExpressionImpl.returnTypeOfCall(candidate);
                if (typeOfCandidate instanceof UnknownType) {
                    return PythonType.UNKNOWN;
                }
                types.add(typeOfCandidate);
            }
            return UnionType.or(types);
        }
        if (calleeType instanceof ObjectType) {
            ObjectType objectType = (ObjectType)calleeType;
            Optional<PythonType> pythonType = objectType.resolveMember("__call__");
            return pythonType.map(CallExpressionImpl::returnTypeOfCall).orElse(PythonType.UNKNOWN);
        }
        return PythonType.UNKNOWN;
    }

    TypeSource calleeTypeSource() {
        Expression expression = this.callee();
        if (expression instanceof QualifiedExpression) {
            QualifiedExpression qualifiedExpression = (QualifiedExpression)expression;
            return qualifiedExpression.qualifier().typeV2().typeSource();
        }
        return this.callee().typeV2().typeSource();
    }
}

