/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.sonar.plugins.python.api.tree.BinaryExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.python.tree.PyTree;
import org.sonar.python.types.HasTypeDependencies;
import org.sonar.python.types.InferredTypes;

public class BinaryExpressionImpl
extends PyTree
implements BinaryExpression,
HasTypeDependencies {
    private static final Map<String, Tree.Kind> KINDS_BY_OPERATOR = Map.ofEntries(Map.entry("+", Tree.Kind.PLUS), Map.entry("-", Tree.Kind.MINUS), Map.entry("*", Tree.Kind.MULTIPLICATION), Map.entry("/", Tree.Kind.DIVISION), Map.entry("//", Tree.Kind.FLOOR_DIVISION), Map.entry("%", Tree.Kind.MODULO), Map.entry("**", Tree.Kind.POWER), Map.entry("@", Tree.Kind.MATRIX_MULTIPLICATION), Map.entry(">>", Tree.Kind.SHIFT_EXPR), Map.entry("<<", Tree.Kind.SHIFT_EXPR), Map.entry("&", Tree.Kind.BITWISE_AND), Map.entry("|", Tree.Kind.BITWISE_OR), Map.entry("^", Tree.Kind.BITWISE_XOR), Map.entry("and", Tree.Kind.AND), Map.entry("or", Tree.Kind.OR), Map.entry("==", Tree.Kind.COMPARISON), Map.entry("<=", Tree.Kind.COMPARISON), Map.entry(">=", Tree.Kind.COMPARISON), Map.entry("<", Tree.Kind.COMPARISON), Map.entry(">", Tree.Kind.COMPARISON), Map.entry("!=", Tree.Kind.COMPARISON), Map.entry("<>", Tree.Kind.COMPARISON), Map.entry("in", Tree.Kind.IN), Map.entry("is", Tree.Kind.IS));
    private final Tree.Kind kind;
    private final Expression leftOperand;
    private final Token operator;
    private final Expression rightOperand;
    private PythonType type = PythonType.UNKNOWN;

    public BinaryExpressionImpl(Expression leftOperand, Token operator, Expression rightOperand) {
        this.kind = KINDS_BY_OPERATOR.get(operator.value());
        this.leftOperand = leftOperand;
        this.operator = operator;
        this.rightOperand = rightOperand;
    }

    @Override
    public Expression leftOperand() {
        return this.leftOperand;
    }

    @Override
    public Token operator() {
        return this.operator;
    }

    @Override
    public Expression rightOperand() {
        return this.rightOperand;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitBinaryExpression(this);
    }

    @Override
    public Tree.Kind getKind() {
        return this.kind;
    }

    @Override
    public List<Tree> computeChildren() {
        return Stream.of(this.leftOperand, this.operator, this.rightOperand).filter(Objects::nonNull).toList();
    }

    @Override
    public InferredType type() {
        if (this.is(Tree.Kind.AND, Tree.Kind.OR)) {
            return InferredTypes.or(this.leftOperand.type(), this.rightOperand.type());
        }
        if (this.is(Tree.Kind.PLUS)) {
            InferredType leftType = this.leftOperand.type();
            InferredType rightType = this.rightOperand.type();
            if (leftType.equals(InferredTypes.INT) && rightType.equals(InferredTypes.INT)) {
                return InferredTypes.INT;
            }
            if (leftType.equals(InferredTypes.STR) && rightType.equals(InferredTypes.STR)) {
                return InferredTypes.STR;
            }
            if (BinaryExpressionImpl.shouldReturnDeclaredInt(leftType, rightType)) {
                return InferredTypes.DECL_INT;
            }
            if (BinaryExpressionImpl.shouldReturnDeclaredStr(leftType, rightType)) {
                return InferredTypes.DECL_STR;
            }
        }
        return InferredTypes.anyType();
    }

    @Override
    public PythonType typeV2() {
        return this.type;
    }

    public BinaryExpressionImpl typeV2(PythonType type) {
        this.type = type;
        return this;
    }

    private static boolean shouldReturnDeclaredStr(InferredType leftType, InferredType rightType) {
        return leftType.equals(InferredTypes.DECL_STR) && rightType.equals(InferredTypes.DECL_STR) || leftType.equals(InferredTypes.STR) && rightType.equals(InferredTypes.DECL_STR) || leftType.equals(InferredTypes.DECL_STR) && rightType.equals(InferredTypes.STR);
    }

    private static boolean shouldReturnDeclaredInt(InferredType leftType, InferredType rightType) {
        return leftType.equals(InferredTypes.DECL_INT) && rightType.equals(InferredTypes.DECL_INT) || leftType.equals(InferredTypes.INT) && rightType.equals(InferredTypes.DECL_INT) || leftType.equals(InferredTypes.DECL_INT) && rightType.equals(InferredTypes.INT);
    }

    @Override
    public List<Expression> typeDependencies() {
        if (this.is(Tree.Kind.AND, Tree.Kind.OR, Tree.Kind.PLUS)) {
            return Arrays.asList(this.leftOperand, this.rightOperand);
        }
        return Collections.emptyList();
    }
}

