/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic.v2.typetable;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.IntStream;
import org.sonar.plugins.python.api.types.v2.ModuleType;
import org.sonar.plugins.python.api.types.v2.ObjectType;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.plugins.python.api.types.v2.TypeWrapper;
import org.sonar.python.semantic.ProjectLevelSymbolTable;
import org.sonar.python.semantic.v2.LazyTypesContext;
import org.sonar.python.semantic.v2.SymbolsModuleTypeProvider;
import org.sonar.python.semantic.v2.typetable.TypeTable;
import org.sonar.python.types.v2.LazyTypeWrapper;

public class ProjectLevelTypeTable
implements TypeTable {
    private final SymbolsModuleTypeProvider symbolsModuleTypeProvider;
    private final PythonType rootModule;
    private final LazyTypesContext lazyTypesContext = new LazyTypesContext(this);
    private final Lock createOrResolveSubModuleLock;

    public ProjectLevelTypeTable(ProjectLevelSymbolTable projectLevelSymbolTable) {
        this.symbolsModuleTypeProvider = new SymbolsModuleTypeProvider(projectLevelSymbolTable, this.lazyTypesContext);
        this.rootModule = this.symbolsModuleTypeProvider.getRootModule();
        this.createOrResolveSubModuleLock = new ReentrantLock();
    }

    @Override
    public PythonType getBuiltinsModule() {
        return this.rootModule;
    }

    @Override
    public PythonType getType(String typeFqn) {
        return this.getType(typeFqn.split("\\."));
    }

    @Override
    public PythonType getType(String ... typeFqnParts) {
        return this.getType(List.of(typeFqnParts));
    }

    @Override
    public PythonType getType(List<String> typeFqnParts) {
        PythonType parent = this.rootModule;
        for (int i = 0; i < typeFqnParts.size(); ++i) {
            LazyTypeWrapper lazyTypeWrapper;
            ModuleType moduleType;
            TypeWrapper typeWrapper;
            String part = typeFqnParts.get(i);
            List<String> moduleFqnParts = IntStream.rangeClosed(0, i).mapToObj(typeFqnParts::get).toList();
            if (parent instanceof ObjectType) {
                return PythonType.UNKNOWN;
            }
            if (parent instanceof ModuleType && (typeWrapper = (moduleType = (ModuleType)parent).members().get(part)) instanceof LazyTypeWrapper && !(lazyTypeWrapper = (LazyTypeWrapper)typeWrapper).isResolved()) {
                if (ProjectLevelTypeTable.shouldResolveImmediately(lazyTypeWrapper, typeFqnParts, i)) {
                    return typeWrapper.type();
                }
                parent = this.createOrResolveSubModule(moduleFqnParts, moduleType);
                continue;
            }
            Optional<PythonType> resolvedMember = parent.resolveMember(part);
            if (resolvedMember.isPresent()) {
                parent = resolvedMember.get();
                continue;
            }
            if (parent instanceof ModuleType) {
                ModuleType module = (ModuleType)parent;
                parent = this.createOrResolveSubModule(moduleFqnParts, module);
                continue;
            }
            return PythonType.UNKNOWN;
        }
        return parent;
    }

    private static boolean shouldResolveImmediately(LazyTypeWrapper lazyTypeWrapper, List<String> typeFqnParts, int i) {
        return i == typeFqnParts.size() - 1 && !lazyTypeWrapper.hasImportPath(String.join((CharSequence)".", typeFqnParts));
    }

    @Override
    public PythonType getModuleType(List<String> typeFqnParts) {
        PythonType parent = this.rootModule;
        for (int i = 0; i < typeFqnParts.size(); ++i) {
            List<String> moduleFqnParts = IntStream.rangeClosed(0, i).mapToObj(typeFqnParts::get).toList();
            if (!(parent instanceof ModuleType)) {
                return PythonType.UNKNOWN;
            }
            ModuleType moduleType = (ModuleType)parent;
            parent = this.createOrResolveSubModule(moduleFqnParts, moduleType);
        }
        return parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PythonType createOrResolveSubModule(List<String> moduleFqn, ModuleType parent) {
        try {
            this.createOrResolveSubModuleLock.lock();
            String part = moduleFqn.get(moduleFqn.size() - 1);
            PythonType pythonType = parent.resolveSubmodule(part).orElseGet(() -> this.symbolsModuleTypeProvider.convertModuleType(moduleFqn, parent));
            return pythonType;
        }
        finally {
            this.createOrResolveSubModuleLock.unlock();
        }
    }

    public LazyTypesContext lazyTypesContext() {
        return this.lazyTypesContext;
    }
}

