/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic.v2.typetable;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.python.semantic.v2.typetable.TypeTable;

public class CachedTypeTable
implements TypeTable {
    private final TypeTable delegate;
    private final Map<List<String>, PythonType> typeCache;
    private final Map<List<String>, PythonType> moduleTypeCache;

    public CachedTypeTable(TypeTable delegate) {
        this.delegate = delegate;
        this.typeCache = new ConcurrentHashMap<List<String>, PythonType>();
        this.moduleTypeCache = new ConcurrentHashMap<List<String>, PythonType>();
    }

    @Override
    public PythonType getBuiltinsModule() {
        return this.delegate.getBuiltinsModule();
    }

    @Override
    public PythonType getType(String typeFqn) {
        List<String> parts = List.of(typeFqn.split("\\."));
        return this.getType(parts);
    }

    @Override
    public PythonType getType(String ... typeFqnParts) {
        return this.getType(List.of(typeFqnParts));
    }

    @Override
    public PythonType getType(List<String> typeFqnParts) {
        PythonType cachedResult = this.typeCache.get(typeFqnParts);
        if (cachedResult != null) {
            return cachedResult;
        }
        PythonType computedResult = this.delegate.getType(typeFqnParts);
        this.typeCache.putIfAbsent(typeFqnParts, computedResult);
        return computedResult;
    }

    @Override
    public PythonType getModuleType(List<String> typeFqnParts) {
        PythonType cachedResult = this.moduleTypeCache.get(typeFqnParts);
        if (cachedResult != null) {
            return cachedResult;
        }
        PythonType computedResult = this.delegate.getModuleType(typeFqnParts);
        this.moduleTypeCache.putIfAbsent(typeFqnParts, computedResult);
        return computedResult;
    }
}

