/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic.v2.typeshed;

import javax.annotation.Nullable;
import org.sonar.python.index.Descriptor;
import org.sonar.python.index.VariableDescriptor;
import org.sonar.python.semantic.v2.typeshed.TypeShedUtils;
import org.sonar.python.types.protobuf.SymbolsProtos;

public class VarSymbolToDescriptorConverter {
    public Descriptor convert(SymbolsProtos.VarSymbol varSymbol) {
        String fullyQualifiedName = TypeShedUtils.normalizedFqn(varSymbol.getFullyQualifiedName());
        SymbolsProtos.Type protoTypeAnnotation = varSymbol.getTypeAnnotation();
        boolean isImportedModule = varSymbol.getIsImportedModule();
        String typeAnnotation = TypeShedUtils.getTypesNormalizedFqn(protoTypeAnnotation);
        if (VarSymbolToDescriptorConverter.isTypeAnnotationKnownToBeIncorrect(fullyQualifiedName)) {
            return new VariableDescriptor(varSymbol.getName(), fullyQualifiedName, null, isImportedModule);
        }
        return new VariableDescriptor(varSymbol.getName(), fullyQualifiedName, typeAnnotation, isImportedModule);
    }

    private static boolean isTypeAnnotationKnownToBeIncorrect(@Nullable String fullyQualifiedName) {
        return "typing.TypedDict".equals(fullyQualifiedName) || "typing_extensions.TypedDict".equals(fullyQualifiedName);
    }
}

