/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic.v2.typeshed;

import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.python.types.protobuf.SymbolsProtos;

public class TypeShedUtils {
    private static final Set<String> EXCLUDING_TYPE_VAR_FQN_PATTERNS = Set.of("^builtins\\.object$", "^_ctypes\\._CanCastTo$");

    private TypeShedUtils() {
    }

    public static String normalizedFqn(String fqn) {
        if (fqn.isEmpty()) {
            return null;
        }
        if (fqn.startsWith("builtins.")) {
            return fqn.substring("builtins.".length());
        }
        return fqn;
    }

    @CheckForNull
    public static String getTypesNormalizedFqn(@Nullable SymbolsProtos.Type type) {
        return Optional.ofNullable(type).map(TypeShedUtils::getTypesFqn).map(TypeShedUtils::normalizedFqn).orElse(null);
    }

    @CheckForNull
    private static String getTypesFqn(SymbolsProtos.Type type) {
        switch (type.getKind()) {
            case INSTANCE: {
                String typeName = type.getFullyQualifiedName();
                return typeName.isEmpty() ? null : typeName;
            }
            case TYPE_ALIAS: {
                return TypeShedUtils.getTypesFqn(type.getArgs(0));
            }
            case TYPE: {
                return "builtins.type";
            }
            case TUPLE: {
                return "builtins.tuple";
            }
            case NONE: {
                return "builtins.NoneType";
            }
            case TYPED_DICT: {
                return "builtins.dict";
            }
            case TYPE_VAR: {
                return Optional.of(type).filter(TypeShedUtils::filterTypeVar).map(SymbolsProtos.Type::getFullyQualifiedName).orElse(null);
            }
        }
        return null;
    }

    public static boolean filterTypeVar(SymbolsProtos.Type type) {
        return Optional.of(type).filter(Predicate.not(t -> t.getPrettyPrintedName().endsWith(".Self"))).map(SymbolsProtos.Type::getFullyQualifiedName).filter(Predicate.not(String::isEmpty)).filter(fqn -> EXCLUDING_TYPE_VAR_FQN_PATTERNS.stream().noneMatch(fqn::matches)).isPresent();
    }
}

