/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic.v2.typeshed;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.plugins.python.api.ProjectPythonVersion;
import org.sonar.plugins.python.api.PythonVersionUtils;
import org.sonar.python.index.ClassDescriptor;
import org.sonar.python.index.Descriptor;
import org.sonar.python.index.ModuleDescriptor;
import org.sonar.python.semantic.v2.typeshed.ModuleSymbolToDescriptorConverter;
import org.sonar.python.types.protobuf.SymbolsProtos;

public class TypeShedDescriptorsProvider {
    private static final Logger LOG = LoggerFactory.getLogger(TypeShedDescriptorsProvider.class);
    private static final String PROTOBUF_BASE_RESOURCE_PATH = "/org/sonar/python/types/";
    private static final String PROTOBUF_CUSTOM_STUBS = "/org/sonar/python/types/custom_protobuf/";
    private static final String PROTOBUF = "/org/sonar/python/types/stdlib_protobuf/";
    private static final String PROTOBUF_THIRD_PARTY = "/org/sonar/python/types/third_party_protobuf/";
    private static final String PROTOBUF_THIRD_PARTY_MYPY = "/org/sonar/python/types/third_party_protobuf_mypy/";
    private static final String PROTOBUF_THIRD_PARTY_MS = "/org/sonar/python/types/third_party_protobuf_microsoft/";
    public static final String BUILTINS_FQN = "builtins";
    private static final Map<String, String> MODULES_TO_DISAMBIGUATE = Map.of("ConfigParser", "2@ConfigParser", "Queue", "2@Queue", "SocketServer", "2@SocketServer");
    private final ModuleSymbolToDescriptorConverter moduleConverter;
    private Map<String, Descriptor> builtins;
    private final Set<String> projectBasePackages;
    private final Map<String, Map<String, Descriptor>> cachedDescriptors;
    private final Map<String, Lock> descriptorsForModuleLocks;

    public TypeShedDescriptorsProvider(Set<String> projectBasePackages) {
        this(projectBasePackages, ProjectPythonVersion.currentVersions());
    }

    public TypeShedDescriptorsProvider(Set<String> projectBasePackages, Set<PythonVersionUtils.Version> projectPythonVersions) {
        this.moduleConverter = new ModuleSymbolToDescriptorConverter(projectPythonVersions);
        this.cachedDescriptors = new ConcurrentHashMap<String, Map<String, Descriptor>>();
        this.descriptorsForModuleLocks = new ConcurrentHashMap<String, Lock>();
        this.projectBasePackages = projectBasePackages;
    }

    public Map<String, Descriptor> builtinDescriptors() {
        Lock lock = this.descriptorsForModuleLocks.computeIfAbsent(BUILTINS_FQN, k -> new ReentrantLock());
        try {
            lock.lock();
            if (this.builtins == null) {
                Map<String, Descriptor> symbols = this.getModuleDescriptors(BUILTINS_FQN, PROTOBUF);
                symbols.put("NoneType", new ClassDescriptor.ClassDescriptorBuilder().withName("NoneType").withFullyQualifiedName("NoneType").build());
                this.builtins = Collections.unmodifiableMap(symbols);
            }
            Map<String, Descriptor> map = this.builtins;
            return map;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Descriptor> descriptorsForModule(String moduleName) {
        Lock lock = this.descriptorsForModuleLocks.computeIfAbsent(moduleName, k -> new ReentrantLock());
        lock.lock();
        try {
            if (this.searchedModuleMatchesCurrentProject(moduleName)) {
                ConcurrentHashMap<String, Descriptor> concurrentHashMap = new ConcurrentHashMap<String, Descriptor>();
                return concurrentHashMap;
            }
            Map map = this.cachedDescriptors.computeIfAbsent(moduleName, this::searchTypeShedForModule);
            return map;
        }
        finally {
            lock.unlock();
        }
    }

    public Set<String> stubModules() {
        return this.cachedDescriptors.keySet();
    }

    private boolean searchedModuleMatchesCurrentProject(String searchedModule) {
        return this.projectBasePackages.contains(searchedModule.split("\\.", 2)[0]);
    }

    private Map<String, Descriptor> searchTypeShedForModule(String moduleName) {
        return Stream.of(PROTOBUF_CUSTOM_STUBS, PROTOBUF, PROTOBUF_THIRD_PARTY_MYPY, PROTOBUF_THIRD_PARTY_MS).map(dirName -> this.getModuleDescriptors(moduleName, (String)dirName)).filter(Predicate.not(Map::isEmpty)).findFirst().orElseGet(() -> this.getModuleDescriptors(moduleName, PROTOBUF_THIRD_PARTY));
    }

    private Map<String, Descriptor> getModuleDescriptors(String moduleName, String dirName) {
        String fileName = MODULES_TO_DISAMBIGUATE.getOrDefault(moduleName, moduleName);
        InputStream resource = this.getClass().getResourceAsStream(dirName + fileName + ".protobuf");
        if (resource == null) {
            return new ConcurrentHashMap<String, Descriptor>(Collections.emptyMap());
        }
        SymbolsProtos.ModuleSymbol moduleSymbol = TypeShedDescriptorsProvider.deserializedModule(moduleName, resource);
        ModuleDescriptor moduleDescriptor = this.moduleConverter.convert(moduleSymbol);
        return new ConcurrentHashMap<String, Descriptor>(Optional.ofNullable(moduleDescriptor).map(ModuleDescriptor::members).orElseGet(Map::of));
    }

    @CheckForNull
    static SymbolsProtos.ModuleSymbol deserializedModule(String moduleName, InputStream resource) {
        try {
            return SymbolsProtos.ModuleSymbol.parseFrom(resource);
        }
        catch (IOException e) {
            LOG.debug("Error while deserializing protobuf for module {}", (Object)moduleName, (Object)e);
            return null;
        }
    }

    public List<Descriptor> stubFilesDescriptors() {
        ArrayList<Descriptor> descriptors = new ArrayList<Descriptor>(new TreeMap<String, Descriptor>(this.builtinDescriptors()).values());
        new TreeMap<String, Map<String, Descriptor>>(this.cachedDescriptors).values().forEach(entry -> descriptors.addAll(new TreeMap(entry).values()));
        return descriptors;
    }
}

