/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic.v2.typeshed;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.python.index.AmbiguousDescriptor;
import org.sonar.python.index.Descriptor;

public class ProtoUtils {
    private ProtoUtils() {
    }

    static Map<String, Descriptor> disambiguateByName(Stream<Stream<? extends Descriptor>> input) {
        return input.flatMap(i -> i).collect(Collectors.groupingBy(Descriptor::name, Collectors.collectingAndThen(Collectors.toSet(), ProtoUtils::disambiguateSymbolsWithSameName)));
    }

    private static Descriptor disambiguateSymbolsWithSameName(Set<Descriptor> descriptors) {
        if (descriptors.size() > 1) {
            return AmbiguousDescriptor.create(descriptors);
        }
        return descriptors.iterator().next();
    }

    static boolean isValidForPythonVersion(List<String> validForPythonVersions, Set<String> supportedPythonVersions) {
        if (validForPythonVersions.isEmpty()) {
            return true;
        }
        HashSet<String> intersection = new HashSet<String>(validForPythonVersions);
        intersection.retainAll(supportedPythonVersions);
        return !intersection.isEmpty();
    }
}

