/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic.v2.typeshed;

import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.python.index.AmbiguousDescriptor;
import org.sonar.python.index.Descriptor;
import org.sonar.python.semantic.v2.typeshed.FunctionSymbolToDescriptorConverter;
import org.sonar.python.semantic.v2.typeshed.TypeShedUtils;
import org.sonar.python.types.protobuf.SymbolsProtos;

public class OverloadedFunctionSymbolToDescriptorConverter {
    private final FunctionSymbolToDescriptorConverter functionConverter;

    public OverloadedFunctionSymbolToDescriptorConverter(FunctionSymbolToDescriptorConverter functionConverter) {
        this.functionConverter = functionConverter;
    }

    public AmbiguousDescriptor convert(SymbolsProtos.OverloadedFunctionSymbol overloadedFunctionSymbol) {
        return this.convert(overloadedFunctionSymbol, false);
    }

    public AmbiguousDescriptor convert(SymbolsProtos.OverloadedFunctionSymbol overloadedFunctionSymbol, boolean isParentIsAClass) {
        if (overloadedFunctionSymbol.getDefinitionsList().size() < 2) {
            throw new IllegalStateException("Overloaded function symbols should have at least two definitions.");
        }
        String name = overloadedFunctionSymbol.getName();
        String fullyQualifiedName = TypeShedUtils.normalizedFqn(overloadedFunctionSymbol.getFullname());
        Set<Descriptor> descriptors = overloadedFunctionSymbol.getDefinitionsList().stream().map(fs -> this.functionConverter.convert((SymbolsProtos.FunctionSymbol)fs, isParentIsAClass)).map(Descriptor.class::cast).collect(Collectors.toSet());
        return new AmbiguousDescriptor(name, fullyQualifiedName, descriptors);
    }
}

