/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic.v2.typeshed;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.PythonVersionUtils;
import org.sonar.python.index.AliasDescriptor;
import org.sonar.python.index.Descriptor;
import org.sonar.python.index.ModuleDescriptor;
import org.sonar.python.semantic.v2.typeshed.ClassSymbolToDescriptorConverter;
import org.sonar.python.semantic.v2.typeshed.FunctionSymbolToDescriptorConverter;
import org.sonar.python.semantic.v2.typeshed.OverloadedFunctionSymbolToDescriptorConverter;
import org.sonar.python.semantic.v2.typeshed.ProtoUtils;
import org.sonar.python.semantic.v2.typeshed.VarSymbolToDescriptorConverter;
import org.sonar.python.types.protobuf.SymbolsProtos;

public class ModuleSymbolToDescriptorConverter {
    private final ClassSymbolToDescriptorConverter classConverter;
    private final FunctionSymbolToDescriptorConverter functionConverter;
    private final VarSymbolToDescriptorConverter variableConverter;
    private final OverloadedFunctionSymbolToDescriptorConverter overloadedFunctionConverter;
    private final Set<String> projectPythonVersions;

    public ModuleSymbolToDescriptorConverter(Set<PythonVersionUtils.Version> projectPythonVersions) {
        this.projectPythonVersions = projectPythonVersions.stream().map(PythonVersionUtils.Version::serializedValue).collect(Collectors.toSet());
        this.functionConverter = new FunctionSymbolToDescriptorConverter();
        this.variableConverter = new VarSymbolToDescriptorConverter();
        this.overloadedFunctionConverter = new OverloadedFunctionSymbolToDescriptorConverter(this.functionConverter);
        this.classConverter = new ClassSymbolToDescriptorConverter(this.variableConverter, this.functionConverter, this.overloadedFunctionConverter, this.projectPythonVersions);
    }

    @CheckForNull
    public ModuleDescriptor convert(@Nullable SymbolsProtos.ModuleSymbol moduleSymbol) {
        if (moduleSymbol == null) {
            return null;
        }
        String name = moduleSymbol.getFullyQualifiedName();
        String fullyQualifiedName = moduleSymbol.getFullyQualifiedName();
        Map<String, Descriptor> members = this.getModuleDescriptors(moduleSymbol);
        return new ModuleDescriptor(name, fullyQualifiedName, members);
    }

    private Map<String, Descriptor> getModuleDescriptors(SymbolsProtos.ModuleSymbol moduleSymbol) {
        Stream<Descriptor> classesStream = moduleSymbol.getClassesList().stream().filter(d -> ProtoUtils.isValidForPythonVersion(d.getValidForList(), this.projectPythonVersions)).map(this.classConverter::convert).map(d -> ModuleSymbolToDescriptorConverter.wrapInAliasIfNeeded(d, moduleSymbol.getFullyQualifiedName())).map(Descriptor.class::cast);
        Stream<Descriptor> functionsStream = moduleSymbol.getFunctionsList().stream().filter(d -> ProtoUtils.isValidForPythonVersion(d.getValidForList(), this.projectPythonVersions)).map(this.functionConverter::convert).map(d -> ModuleSymbolToDescriptorConverter.wrapInAliasIfNeeded(d, moduleSymbol.getFullyQualifiedName())).map(Descriptor.class::cast);
        Stream<Descriptor> overloadedFunctionsStream = moduleSymbol.getOverloadedFunctionsList().stream().filter(d -> ProtoUtils.isValidForPythonVersion(d.getValidForList(), this.projectPythonVersions)).map(this.overloadedFunctionConverter::convert).map(Descriptor.class::cast);
        Stream<Descriptor> variablesStream = moduleSymbol.getVarsList().stream().filter(d -> ProtoUtils.isValidForPythonVersion(d.getValidForList(), this.projectPythonVersions)).map(this.variableConverter::convert).map(Descriptor.class::cast);
        return ProtoUtils.disambiguateByName(Stream.of(classesStream, functionsStream, overloadedFunctionsStream, variablesStream));
    }

    private static Descriptor wrapInAliasIfNeeded(Descriptor descriptor, String moduleFullyQualifiedName) {
        String descriptorFqn;
        String normalizedModuleFqn = moduleFullyQualifiedName;
        if (moduleFullyQualifiedName.startsWith("builtins")) {
            normalizedModuleFqn = moduleFullyQualifiedName.substring("builtins".length());
        }
        if ((descriptorFqn = descriptor.fullyQualifiedName()) == null) {
            return descriptor;
        }
        if (!descriptorFqn.startsWith(normalizedModuleFqn)) {
            String aliasFqn = normalizedModuleFqn + "." + descriptor.name();
            return new AliasDescriptor(descriptor.name(), aliasFqn, descriptor);
        }
        return descriptor;
    }
}

