/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic.v2.typeshed;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.sonar.python.index.FunctionDescriptor;
import org.sonar.python.index.TypeAnnotationDescriptor;
import org.sonar.python.semantic.v2.typeshed.ParameterSymbolToDescriptorConverter;
import org.sonar.python.semantic.v2.typeshed.TypeShedUtils;
import org.sonar.python.semantic.v2.typeshed.TypeSymbolToDescriptorConverter;
import org.sonar.python.types.protobuf.SymbolsProtos;

public class FunctionSymbolToDescriptorConverter {
    private final ParameterSymbolToDescriptorConverter parameterConverter = new ParameterSymbolToDescriptorConverter();
    private final TypeSymbolToDescriptorConverter typeConverter = new TypeSymbolToDescriptorConverter();

    public FunctionDescriptor convert(SymbolsProtos.FunctionSymbol functionSymbol) {
        return this.convert(functionSymbol, false);
    }

    public FunctionDescriptor convert(SymbolsProtos.FunctionSymbol functionSymbol, boolean isParentIsAClass) {
        String fullyQualifiedName = TypeShedUtils.normalizedFqn(functionSymbol.getFullyQualifiedName());
        TypeAnnotationDescriptor typeAnnotationDescriptor = null;
        if (functionSymbol.hasReturnAnnotation()) {
            SymbolsProtos.Type returnAnnotation = functionSymbol.getReturnAnnotation();
            typeAnnotationDescriptor = this.typeConverter.convert(returnAnnotation);
        }
        String returnType = TypeShedUtils.getTypesNormalizedFqn(functionSymbol.getReturnAnnotation());
        List<String> decorators = Optional.of(functionSymbol).map(SymbolsProtos.FunctionSymbol::getResolvedDecoratorNamesList).stream().flatMap(Collection::stream).map(TypeShedUtils::normalizedFqn).toList();
        List<FunctionDescriptor.Parameter> parameters = functionSymbol.getParametersList().stream().map(this.parameterConverter::convert).toList();
        boolean isInstanceMethod = isParentIsAClass && !functionSymbol.getIsStatic() && !functionSymbol.getIsClassMethod();
        return new FunctionDescriptor.FunctionDescriptorBuilder().withName(functionSymbol.getName()).withFullyQualifiedName(fullyQualifiedName).withIsAsynchronous(functionSymbol.getIsAsynchronous()).withIsInstanceMethod(isInstanceMethod).withHasDecorators(functionSymbol.getHasDecorators()).withAnnotatedReturnTypeName(returnType).withTypeAnnotationDescriptor(typeAnnotationDescriptor).withDecorators(decorators).withParameters(parameters).build();
    }
}

