/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic.v2.typeshed;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.python.index.AmbiguousDescriptor;
import org.sonar.python.index.ClassDescriptor;
import org.sonar.python.index.Descriptor;
import org.sonar.python.index.FunctionDescriptor;
import org.sonar.python.semantic.v2.typeshed.FunctionSymbolToDescriptorConverter;
import org.sonar.python.semantic.v2.typeshed.OverloadedFunctionSymbolToDescriptorConverter;
import org.sonar.python.semantic.v2.typeshed.ProtoUtils;
import org.sonar.python.semantic.v2.typeshed.TypeShedUtils;
import org.sonar.python.semantic.v2.typeshed.VarSymbolToDescriptorConverter;
import org.sonar.python.types.protobuf.SymbolsProtos;

public class ClassSymbolToDescriptorConverter {
    private final VarSymbolToDescriptorConverter varConverter;
    private final FunctionSymbolToDescriptorConverter functionConverter;
    private final OverloadedFunctionSymbolToDescriptorConverter overloadedFunctionConverter;
    private final Set<String> projectPythonVersions;

    public ClassSymbolToDescriptorConverter(VarSymbolToDescriptorConverter varConverter, FunctionSymbolToDescriptorConverter functionConverter, OverloadedFunctionSymbolToDescriptorConverter overloadedFunctionConverter, Set<String> projectPythonVersions) {
        this.varConverter = varConverter;
        this.functionConverter = functionConverter;
        this.overloadedFunctionConverter = overloadedFunctionConverter;
        this.projectPythonVersions = projectPythonVersions;
    }

    public ClassDescriptor convert(SymbolsProtos.ClassSymbol classSymbol) {
        String fullyQualifiedName = TypeShedUtils.normalizedFqn(classSymbol.getFullyQualifiedName());
        List<String> superClasses = classSymbol.getSuperClassesList().stream().map(TypeShedUtils::normalizedFqn).toList();
        String metaclassName = TypeShedUtils.normalizedFqn(classSymbol.getMetaclassName());
        Stream<Descriptor> variableDescriptors = classSymbol.getAttributesList().stream().filter(d -> ProtoUtils.isValidForPythonVersion(d.getValidForList(), this.projectPythonVersions)).map(this.varConverter::convert);
        Stream<FunctionDescriptor> functionDescriptors = classSymbol.getMethodsList().stream().filter(d -> ProtoUtils.isValidForPythonVersion(d.getValidForList(), this.projectPythonVersions)).map(s -> this.functionConverter.convert((SymbolsProtos.FunctionSymbol)s, true));
        Stream<AmbiguousDescriptor> overloadedFunctionDescriptors = classSymbol.getOverloadedMethodsList().stream().filter(d -> ProtoUtils.isValidForPythonVersion(d.getValidForList(), this.projectPythonVersions)).map(s -> this.overloadedFunctionConverter.convert((SymbolsProtos.OverloadedFunctionSymbol)s, true));
        Stream<ClassDescriptor> nestedClassesDescriptors = classSymbol.getNestedClassesList().stream().filter(d -> ProtoUtils.isValidForPythonVersion(d.getValidForList(), this.projectPythonVersions)).map(this::convert);
        Set<Descriptor> members = ProtoUtils.disambiguateByName(Stream.of(variableDescriptors, functionDescriptors, overloadedFunctionDescriptors, nestedClassesDescriptors)).values().stream().map(Descriptor.class::cast).collect(Collectors.toSet());
        return new ClassDescriptor.ClassDescriptorBuilder().withName(classSymbol.getName()).withFullyQualifiedName(fullyQualifiedName).withSuperClasses(superClasses).withMetaclassFQN(metaclassName).withHasMetaClass(classSymbol.getHasMetaclass()).withHasDecorators(classSymbol.getHasDecorators()).withSupportsGenerics(classSymbol.getIsGeneric()).withMembers(members).build();
    }
}

