/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic.v2.types;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.python.cfg.fixpoint.ProgramState;
import org.sonar.python.semantic.v2.SymbolV2;

public class TypeInferenceProgramState
implements ProgramState {
    private final Map<SymbolV2, Set<PythonType>> typesBySymbol = new HashMap<SymbolV2, Set<PythonType>>();

    public void setTypes(SymbolV2 symbol, Set<PythonType> types) {
        this.typesBySymbol.put(symbol, types);
    }

    Set<PythonType> getTypes(@Nullable SymbolV2 symbol) {
        return this.typesBySymbol.getOrDefault(symbol, Collections.emptySet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeInferenceProgramState that = (TypeInferenceProgramState)o;
        return Objects.equals(this.typesBySymbol, that.typesBySymbol);
    }

    public int hashCode() {
        return Objects.hash(this.typesBySymbol);
    }

    @Override
    public ProgramState join(ProgramState otherState) {
        TypeInferenceProgramState result = new TypeInferenceProgramState();
        ((TypeInferenceProgramState)otherState).typesBySymbol.forEach((symbol, types) -> {
            HashSet<PythonType> union = new HashSet<PythonType>((Collection<PythonType>)types);
            union.addAll(this.typesBySymbol.getOrDefault(symbol, Collections.emptySet()));
            result.setTypes((SymbolV2)symbol, (Set<PythonType>)union);
        });
        this.typesBySymbol.forEach((symbol, types) -> {
            if (!result.typesBySymbol.containsKey(symbol)) {
                result.setTypes((SymbolV2)symbol, (Set<PythonType>)types);
            }
        });
        return result;
    }

    @Override
    public ProgramState copy() {
        return this.join(new TypeInferenceProgramState());
    }

    public Map<SymbolV2, Set<PythonType>> typesBySymbol() {
        return this.typesBySymbol;
    }
}

