/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic.v2.types;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.sonar.plugins.python.api.tree.BinaryExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.types.HasTypeDependencies;

public class TypeDependenciesCalculator {
    static final Set<Tree.Kind> SAME_TYPE_PRODUCING_BINARY_EXPRESSION_KINDS = EnumSet.of(Tree.Kind.PLUS, new Tree.Kind[]{Tree.Kind.MINUS, Tree.Kind.MULTIPLICATION, Tree.Kind.DIVISION, Tree.Kind.FLOOR_DIVISION, Tree.Kind.MODULO, Tree.Kind.POWER});

    public boolean hasTypeDependencies(Expression expression) {
        return expression instanceof HasTypeDependencies;
    }

    public List<Expression> getTypeDependencies(Expression expression) {
        if (expression instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            return TypeDependenciesCalculator.calculateBinaryExpressionTypeDependencies(binaryExpression);
        }
        if (expression instanceof HasTypeDependencies) {
            HasTypeDependencies hasTypeDependencies = (HasTypeDependencies)((Object)expression);
            return hasTypeDependencies.typeDependencies();
        }
        return List.of();
    }

    private static List<Expression> calculateBinaryExpressionTypeDependencies(BinaryExpression binaryExpression) {
        if (SAME_TYPE_PRODUCING_BINARY_EXPRESSION_KINDS.contains((Object)binaryExpression.getKind()) || binaryExpression.is(Tree.Kind.AND, Tree.Kind.OR)) {
            return List.of(binaryExpression.leftOperand(), binaryExpression.rightOperand());
        }
        return List.of();
    }
}

