/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic.v2.types;

import org.sonar.plugins.python.api.TriBool;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.BinaryExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.UnaryExpression;
import org.sonar.plugins.python.api.types.v2.ClassType;
import org.sonar.plugins.python.api.types.v2.ObjectType;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.plugins.python.api.types.v2.TypeSource;
import org.sonar.plugins.python.api.types.v2.UnionType;
import org.sonar.python.semantic.v2.types.TypeDependenciesCalculator;
import org.sonar.python.semantic.v2.typetable.TypeTable;
import org.sonar.python.tree.BinaryExpressionImpl;
import org.sonar.python.tree.UnaryExpressionImpl;
import org.sonar.python.types.v2.TypeCheckBuilder;
import org.sonar.python.types.v2.TypeUtils;

public class TrivialTypePropagationVisitor
extends BaseTreeVisitor {
    private final TypeCheckBuilder isBooleanTypeCheck;
    private final TypeCheckBuilder isIntTypeCheck;
    private final TypeCheckBuilder isFloatTypeCheck;
    private final TypeCheckBuilder isComplexTypeCheck;
    private final PythonType intType;
    private final PythonType boolType;

    public TrivialTypePropagationVisitor(TypeTable typeTable) {
        this.isBooleanTypeCheck = new TypeCheckBuilder(typeTable).isBuiltinWithName("bool");
        this.isIntTypeCheck = new TypeCheckBuilder(typeTable).isBuiltinWithName("int");
        this.isFloatTypeCheck = new TypeCheckBuilder(typeTable).isBuiltinWithName("float");
        this.isComplexTypeCheck = new TypeCheckBuilder(typeTable).isBuiltinWithName("complex");
        PythonType builtins = typeTable.getBuiltinsModule();
        this.intType = builtins.resolveMember("int").orElse(PythonType.UNKNOWN);
        this.boolType = builtins.resolveMember("bool").orElse(PythonType.UNKNOWN);
    }

    @Override
    public void visitUnaryExpression(UnaryExpression unaryExpr) {
        super.visitUnaryExpression(unaryExpr);
        PythonType exprType = this.calculateUnaryExprType(unaryExpr);
        if (unaryExpr instanceof UnaryExpressionImpl) {
            UnaryExpressionImpl unaryExprImpl = (UnaryExpressionImpl)unaryExpr;
            unaryExprImpl.typeV2(TrivialTypePropagationVisitor.toObjectType(exprType));
        }
    }

    @Override
    public void visitBinaryExpression(BinaryExpression binaryExpression) {
        super.visitBinaryExpression(binaryExpression);
        if (binaryExpression instanceof BinaryExpressionImpl) {
            BinaryExpressionImpl binaryExpressionImpl = (BinaryExpressionImpl)binaryExpression;
            PythonType type = TrivialTypePropagationVisitor.calculateBinaryExpressionType(binaryExpression);
            binaryExpressionImpl.typeV2(type);
        }
    }

    private static PythonType calculateBinaryExpressionType(BinaryExpression binaryExpression) {
        ObjectType leftObjectType;
        PythonType pythonType;
        Tree.Kind kind = binaryExpression.getKind();
        Expression leftOperand = binaryExpression.leftOperand();
        Expression rightOperand = binaryExpression.rightOperand();
        if (binaryExpression.is(Tree.Kind.AND, Tree.Kind.OR)) {
            return UnionType.or(leftOperand.typeV2(), rightOperand.typeV2(), new PythonType[0]);
        }
        if (TypeDependenciesCalculator.SAME_TYPE_PRODUCING_BINARY_EXPRESSION_KINDS.contains((Object)kind) && (pythonType = leftOperand.typeV2()) instanceof ObjectType && (pythonType = (leftObjectType = (ObjectType)pythonType).unwrappedType()) instanceof ClassType) {
            ClassType rightClassType;
            ObjectType rightObjectType;
            ClassType leftClassType = (ClassType)pythonType;
            pythonType = rightOperand.typeV2();
            if (pythonType instanceof ObjectType && (pythonType = (rightObjectType = (ObjectType)pythonType).unwrappedType()) instanceof ClassType && leftClassType == (rightClassType = (ClassType)pythonType)) {
                return new ObjectType(leftClassType, TypeSource.min(leftObjectType.typeSource(), rightObjectType.typeSource()));
            }
        }
        return PythonType.UNKNOWN;
    }

    private PythonType calculateUnaryExprType(UnaryExpression unaryExpr) {
        String operator = unaryExpr.operator().value();
        return TypeUtils.map(unaryExpr.expression().typeV2(), type -> this.mapUnaryExprType(operator, (PythonType)type));
    }

    private PythonType mapUnaryExprType(String operator, PythonType type) {
        return switch (operator) {
            case "~" -> this.mapInvertExprType(type);
            case "not" -> this.boolType;
            case "+", "-" -> this.mapUnaryPlusMinusType(type);
            default -> PythonType.UNKNOWN;
        };
    }

    private PythonType mapInvertExprType(PythonType type) {
        if (this.isIntTypeCheck.check(type) == TriBool.TRUE || this.isBooleanTypeCheck.check(type) == TriBool.TRUE) {
            return this.intType;
        }
        return PythonType.UNKNOWN;
    }

    private PythonType mapUnaryPlusMinusType(PythonType type) {
        if (this.isNumber(type)) {
            return type;
        }
        if (this.isBooleanTypeCheck.check(type) == TriBool.TRUE) {
            return TrivialTypePropagationVisitor.toObjectType(this.intType);
        }
        return PythonType.UNKNOWN;
    }

    private boolean isNumber(PythonType type) {
        return this.isIntTypeCheck.check(type) == TriBool.TRUE || this.isFloatTypeCheck.check(type) == TriBool.TRUE || this.isComplexTypeCheck.check(type) == TriBool.TRUE;
    }

    private static PythonType toObjectType(PythonType type) {
        if (type == PythonType.UNKNOWN) {
            return type;
        }
        if (type instanceof ObjectType) {
            ObjectType objectType = (ObjectType)type;
            return new ObjectType(objectType.typeWrapper(), objectType.attributes(), objectType.members(), objectType.typeSource());
        }
        return new ObjectType(type);
    }
}

