/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic.v2.types;

import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.TriBool;
import org.sonar.plugins.python.api.tree.AliasedName;
import org.sonar.plugins.python.api.tree.AnnotatedAssignment;
import org.sonar.plugins.python.api.tree.ArgList;
import org.sonar.plugins.python.api.tree.AssignmentExpression;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.BinaryExpression;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.ComprehensionExpression;
import org.sonar.plugins.python.api.tree.DictCompExpression;
import org.sonar.plugins.python.api.tree.DictionaryLiteral;
import org.sonar.plugins.python.api.tree.DottedName;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ExpressionList;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.ImportFrom;
import org.sonar.plugins.python.api.tree.ImportName;
import org.sonar.plugins.python.api.tree.ListLiteral;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.NoneExpression;
import org.sonar.plugins.python.api.tree.NumericLiteral;
import org.sonar.plugins.python.api.tree.Parameter;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.SetLiteral;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.SubscriptionExpression;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Tuple;
import org.sonar.plugins.python.api.tree.TypeAnnotation;
import org.sonar.plugins.python.api.types.v2.ClassType;
import org.sonar.plugins.python.api.types.v2.FunctionType;
import org.sonar.plugins.python.api.types.v2.Member;
import org.sonar.plugins.python.api.types.v2.ModuleType;
import org.sonar.plugins.python.api.types.v2.ObjectType;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.plugins.python.api.types.v2.TypeOrigin;
import org.sonar.plugins.python.api.types.v2.TypeSource;
import org.sonar.plugins.python.api.types.v2.TypeWrapper;
import org.sonar.plugins.python.api.types.v2.UnionType;
import org.sonar.plugins.python.api.types.v2.UnknownType;
import org.sonar.python.semantic.SymbolUtils;
import org.sonar.python.semantic.v2.ClassTypeBuilder;
import org.sonar.python.semantic.v2.FunctionTypeBuilder;
import org.sonar.python.semantic.v2.SymbolV2;
import org.sonar.python.semantic.v2.UsageV2;
import org.sonar.python.semantic.v2.typetable.TypeTable;
import org.sonar.python.tree.ComprehensionExpressionImpl;
import org.sonar.python.tree.DictCompExpressionImpl;
import org.sonar.python.tree.DictionaryLiteralImpl;
import org.sonar.python.tree.ListLiteralImpl;
import org.sonar.python.tree.NameImpl;
import org.sonar.python.tree.NoneExpressionImpl;
import org.sonar.python.tree.NumericLiteralImpl;
import org.sonar.python.tree.SetLiteralImpl;
import org.sonar.python.tree.StringLiteralImpl;
import org.sonar.python.tree.SubscriptionExpressionImpl;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.tree.TupleImpl;
import org.sonar.python.types.v2.SpecialFormType;
import org.sonar.python.types.v2.TypeChecker;

public class TrivialTypeInferenceVisitor
extends BaseTreeVisitor {
    private final TypeTable projectLevelTypeTable;
    private final String fileId;
    private final String fullyQualifiedModuleName;
    private final String moduleName;
    private final Deque<Scope> typeStack = new ArrayDeque<Scope>();
    private final Set<String> importedModulesFQN = new HashSet<String>();
    private final TypeChecker typeChecker;
    private final List<String> typeVarNames = new ArrayList<String>();
    private final Map<String, TypeWrapper> wildcardImportedTypes = new HashMap<String, TypeWrapper>();

    public TrivialTypeInferenceVisitor(TypeTable projectLevelTypeTable, PythonFile pythonFile, String fullyQualifiedModuleName) {
        this.projectLevelTypeTable = projectLevelTypeTable;
        Path path = SymbolUtils.pathOf(pythonFile);
        this.moduleName = pythonFile.fileName();
        this.fileId = path != null ? path.toString() : pythonFile.toString();
        this.fullyQualifiedModuleName = fullyQualifiedModuleName;
        this.typeChecker = new TypeChecker(projectLevelTypeTable);
    }

    public Set<String> importedModulesFQN() {
        return this.importedModulesFQN;
    }

    @Override
    public void visitFileInput(FileInput fileInput) {
        ModuleType type = new ModuleType(this.moduleName);
        this.inTypeScope(type, () -> super.visitFileInput(fileInput));
    }

    @Override
    public void visitStringLiteral(StringLiteral stringLiteral) {
        PythonType builtins = this.projectLevelTypeTable.getBuiltinsModule();
        if (((StringLiteralImpl)stringLiteral).isTemplate()) {
            ((StringLiteralImpl)stringLiteral).typeV2(new ObjectType(PythonType.UNKNOWN, new ArrayList<PythonType>(), new ArrayList<Member>()));
        } else {
            PythonType strType = builtins.resolveMember("str").orElse(PythonType.UNKNOWN);
            ((StringLiteralImpl)stringLiteral).typeV2(new ObjectType(strType, new ArrayList<PythonType>(), new ArrayList<Member>()));
        }
    }

    @Override
    public void visitTuple(Tuple tuple) {
        super.visitTuple(tuple);
        List<PythonType> contentTypes = tuple.elements().stream().map(Expression::typeV2).distinct().toList();
        ArrayList<PythonType> attributes = new ArrayList();
        if (contentTypes.size() == 1 && !contentTypes.get(0).equals(PythonType.UNKNOWN)) {
            attributes = contentTypes;
        }
        PythonType builtins = this.projectLevelTypeTable.getBuiltinsModule();
        PythonType tupleType = builtins.resolveMember("tuple").orElse(PythonType.UNKNOWN);
        ((TupleImpl)tuple).typeV2(new ObjectType(tupleType, attributes, new ArrayList<Member>()));
    }

    @Override
    public void visitDictionaryLiteral(DictionaryLiteral dictionaryLiteral) {
        super.visitDictionaryLiteral(dictionaryLiteral);
        PythonType builtins = this.projectLevelTypeTable.getBuiltinsModule();
        PythonType dictType = builtins.resolveMember("dict").orElse(PythonType.UNKNOWN);
        ((DictionaryLiteralImpl)dictionaryLiteral).typeV2(new ObjectType(dictType, new ArrayList<PythonType>(), new ArrayList<Member>()));
    }

    @Override
    public void visitSetLiteral(SetLiteral setLiteral) {
        super.visitSetLiteral(setLiteral);
        PythonType builtins = this.projectLevelTypeTable.getBuiltinsModule();
        PythonType setType = builtins.resolveMember("set").orElse(PythonType.UNKNOWN);
        ((SetLiteralImpl)setLiteral).typeV2(new ObjectType(setType, new ArrayList<PythonType>(), new ArrayList<Member>()));
    }

    @Override
    public void visitNumericLiteral(NumericLiteral numericLiteral) {
        PythonType builtins = this.projectLevelTypeTable.getBuiltinsModule();
        NumericLiteralImpl numericLiteralImpl = (NumericLiteralImpl)numericLiteral;
        NumericLiteralImpl.NumericKind numericKind = numericLiteralImpl.numericKind();
        PythonType pythonType = builtins.resolveMember(numericKind.value()).orElse(PythonType.UNKNOWN);
        numericLiteralImpl.typeV2(new ObjectType(pythonType, new ArrayList<PythonType>(), new ArrayList<Member>()));
    }

    @Override
    public void visitNone(NoneExpression noneExpression) {
        PythonType builtins = this.projectLevelTypeTable.getBuiltinsModule();
        PythonType noneType = builtins.resolveMember("NoneType").orElse(PythonType.UNKNOWN);
        ((NoneExpressionImpl)noneExpression).typeV2(new ObjectType(noneType, new ArrayList<PythonType>(), new ArrayList<Member>()));
    }

    @Override
    public void visitListLiteral(ListLiteral listLiteral) {
        PythonType builtins = this.projectLevelTypeTable.getBuiltinsModule();
        this.scan(listLiteral.elements());
        List<PythonType> candidateTypes = listLiteral.elements().expressions().stream().map(Expression::typeV2).distinct().toList();
        PythonType elementsType = UnionType.or(candidateTypes);
        ArrayList<PythonType> attributes = new ArrayList<PythonType>();
        attributes.add(elementsType);
        PythonType listType = builtins.resolveMember("list").orElse(PythonType.UNKNOWN);
        ((ListLiteralImpl)listLiteral).typeV2(new ObjectType(listType, attributes, new ArrayList<Member>()));
    }

    @Override
    public void visitPyListOrSetCompExpression(ComprehensionExpression comprehensionExpression) {
        super.visitPyListOrSetCompExpression(comprehensionExpression);
        PythonType builtins = this.projectLevelTypeTable.getBuiltinsModule();
        PythonType pythonType = switch (comprehensionExpression.getKind()) {
            case Tree.Kind.LIST_COMPREHENSION -> builtins.resolveMember("list").orElse(PythonType.UNKNOWN);
            case Tree.Kind.SET_COMPREHENSION -> builtins.resolveMember("set").orElse(PythonType.UNKNOWN);
            default -> PythonType.UNKNOWN;
        };
        ((ComprehensionExpressionImpl)comprehensionExpression).typeV2(new ObjectType(pythonType, new ArrayList<PythonType>(), new ArrayList<Member>()));
    }

    @Override
    public void visitDictCompExpression(DictCompExpression dictCompExpression) {
        super.visitDictCompExpression(dictCompExpression);
        PythonType builtins = this.projectLevelTypeTable.getBuiltinsModule();
        PythonType dictType = builtins.resolveMember("dict").orElse(PythonType.UNKNOWN);
        ((DictCompExpressionImpl)dictCompExpression).typeV2(new ObjectType(dictType, new ArrayList<PythonType>(), new ArrayList<Member>()));
    }

    @Override
    public void visitClassDef(ClassDef classDef) {
        this.scan(classDef.args());
        Name name = classDef.name();
        ClassType type = this.buildClassType(classDef);
        ((NameImpl)name).typeV2(type);
        this.inTypeScope(type, () -> this.scan(classDef.body()));
    }

    private ClassType buildClassType(ClassDef classDef) {
        Name className = classDef.name();
        String fullyQualifiedName = this.currentScopeFullyQualifiedName() + "." + classDef.name().name();
        ClassTypeBuilder classTypeBuilder = new ClassTypeBuilder(className.name(), fullyQualifiedName).withHasDecorators(!classDef.decorators().isEmpty()).withDefinitionLocation(TreeUtils.locationInFile(className, this.fileId));
        this.resolveTypeHierarchy(classDef, classTypeBuilder);
        if (classDef.typeParams() != null) {
            classTypeBuilder.withIsGeneric(true);
        }
        ClassType classType = classTypeBuilder.build();
        PythonType pythonType = this.currentType();
        if (pythonType instanceof ClassType) {
            ClassType ownerClass = (ClassType)pythonType;
            SymbolV2 symbolV2 = className.symbolV2();
            if (symbolV2 != null) {
                PythonType memberType = symbolV2.hasSingleBindingUsage() ? classType : PythonType.UNKNOWN;
                ownerClass.members().add(new Member(classType.name(), memberType));
            }
        }
        return classType;
    }

    void resolveTypeHierarchy(ClassDef classDef, ClassTypeBuilder classTypeBuilder) {
        Optional.of(classDef).map(ClassDef::args).map(ArgList::arguments).stream().flatMap(Collection::stream).forEach(argument -> {
            if (argument instanceof RegularArgument) {
                RegularArgument regularArgument = (RegularArgument)argument;
                this.addParentClass(classTypeBuilder, regularArgument);
            } else {
                classTypeBuilder.addSuperClass(PythonType.UNKNOWN);
            }
        });
    }

    private void addParentClass(ClassTypeBuilder classTypeBuilder, RegularArgument regularArgument) {
        Name keyword = regularArgument.keywordArgument();
        if (keyword != null) {
            if ("metaclass".equals(keyword.name())) {
                PythonType argumentType = TrivialTypeInferenceVisitor.getTypeV2FromArgument(regularArgument);
                classTypeBuilder.metaClasses().add(argumentType);
            }
            return;
        }
        PythonType argumentType = TrivialTypeInferenceVisitor.getTypeV2FromArgument(regularArgument);
        classTypeBuilder.addSuperClass(argumentType);
        if (this.isParentAGenericClass(regularArgument, argumentType)) {
            classTypeBuilder.withIsGeneric(true);
        }
    }

    private boolean isParentAGenericClass(RegularArgument regularArgument, PythonType argumentType) {
        SubscriptionExpression subscriptionExpression;
        Expression expression2;
        return this.typeChecker.typeCheckBuilder().isGeneric().check(argumentType) == TriBool.TRUE && (expression2 = regularArgument.expression()) instanceof SubscriptionExpression && (subscriptionExpression = (SubscriptionExpression)expression2).subscripts().expressions().stream().anyMatch(expression -> {
            Name name;
            return expression instanceof Name && this.typeVarNames.contains((name = (Name)expression).name());
        });
    }

    private static PythonType getTypeV2FromArgument(RegularArgument regularArgument) {
        Expression expression = regularArgument.expression();
        return expression.typeV2();
    }

    @Override
    public void visitFunctionDef(FunctionDef functionDef) {
        this.scan(functionDef.decorators());
        this.scan(functionDef.typeParams());
        this.scan(functionDef.parameters());
        this.scan(functionDef.returnTypeAnnotation());
        FunctionType functionType = this.buildFunctionType(functionDef);
        ((NameImpl)functionDef.name()).typeV2(functionType);
        this.inTypeScope(functionType, () -> {
            this.scan(functionDef.typeParams());
            this.scan(functionDef.parameters());
            this.scan(functionDef.body());
        });
    }

    private FunctionType buildFunctionType(FunctionDef functionDef) {
        TypeAnnotation typeAnnotation;
        String fullyQualifiedName = this.currentScopeFullyQualifiedName() + "." + functionDef.name().name();
        FunctionTypeBuilder functionTypeBuilder = new FunctionTypeBuilder().fromFunctionDef(functionDef, fullyQualifiedName, this.fileId, this.projectLevelTypeTable).withDefinitionLocation(TreeUtils.locationInFile(functionDef.name(), this.fileId));
        ClassType owner = null;
        PythonType pythonType = this.currentType();
        if (pythonType instanceof ClassType) {
            ClassType classType;
            owner = classType = (ClassType)pythonType;
        }
        if (owner != null) {
            functionTypeBuilder.withOwner(owner);
        }
        if ((typeAnnotation = functionDef.returnTypeAnnotation()) != null) {
            PythonType returnType = typeAnnotation.expression().typeV2();
            functionTypeBuilder.withReturnType(returnType instanceof UnknownType ? returnType : new ObjectType(returnType, TypeSource.TYPE_HINT));
            functionTypeBuilder.withTypeOrigin(TypeOrigin.LOCAL);
        }
        FunctionType functionType = functionTypeBuilder.build();
        SymbolV2 symbolV2 = functionDef.name().symbolV2();
        if (owner != null && symbolV2 != null) {
            if (symbolV2.hasSingleBindingUsage()) {
                owner.members().add(new Member(functionType.name(), functionType));
            } else {
                owner.members().add(new Member(functionType.name(), PythonType.UNKNOWN));
            }
        }
        return functionType;
    }

    @Override
    public void visitImportName(ImportName importName) {
        importName.modules().forEach(aliasedName -> {
            DottedName dottedName = aliasedName.dottedName();
            List<String> fqn = TrivialTypeInferenceVisitor.dottedNameToPartFqn(dottedName);
            PythonType resolvedType = this.projectLevelTypeTable.getModuleType(fqn);
            this.importedModulesFQN.add(String.join((CharSequence)".", fqn));
            if (aliasedName.alias() != null) {
                TrivialTypeInferenceVisitor.generateNamesForImportAlias(aliasedName, resolvedType, fqn);
            } else {
                TrivialTypeInferenceVisitor.generateNames(resolvedType, dottedName.names(), fqn);
            }
        });
    }

    private static void generateNamesForImportAlias(AliasedName aliasedName, PythonType resolvedType, List<String> fqn) {
        PythonType aliasedNameType = resolvedType instanceof UnknownType ? new UnknownType.UnresolvedImportType(String.join((CharSequence)".", fqn)) : resolvedType;
        TrivialTypeInferenceVisitor.setTypeToName(aliasedName.alias(), aliasedNameType);
    }

    private static void generateNames(PythonType resolvedType, List<Name> names, List<String> fqn) {
        block3: {
            block2: {
                if (!(resolvedType instanceof ModuleType)) break block2;
                ModuleType module = (ModuleType)resolvedType;
                for (int i = names.size() - 1; i >= 0; --i) {
                    TrivialTypeInferenceVisitor.setTypeToName(names.get(i), module);
                    module = Optional.ofNullable(module).map(ModuleType::parent).orElse(null);
                }
                break block3;
            }
            if (!(resolvedType instanceof UnknownType)) break block3;
            for (int i = names.size() - 1; i >= 0; --i) {
                UnknownType.UnresolvedImportType type = new UnknownType.UnresolvedImportType(String.join((CharSequence)".", fqn.subList(0, i + 1)));
                TrivialTypeInferenceVisitor.setTypeToName(names.get(i), type);
            }
        }
    }

    @Override
    public void visitImportFrom(ImportFrom importFrom) {
        List<String> fromModuleFqn = this.getFromImportModuleFqn(importFrom);
        this.importedModulesFQN.add(String.join((CharSequence)".", fromModuleFqn));
        this.setTypeToImportFromStatement(importFrom, fromModuleFqn);
        if (importFrom.isWildcardImport()) {
            this.collectWildcardImportedSymbols(fromModuleFqn);
        }
    }

    private List<String> getFromImportModuleFqn(ImportFrom importFrom) {
        List fromModuleFqn = Optional.ofNullable(importFrom.module()).map(TrivialTypeInferenceVisitor::dottedNameToPartFqn).orElse(new ArrayList());
        List<Token> dotPrefixTokens = importFrom.dottedPrefixForModule();
        if (!dotPrefixTokens.isEmpty()) {
            List<String> moduleFqnElements = List.of(this.fullyQualifiedModuleName.split("\\."));
            int dotPrefixTokensSize = dotPrefixTokens.size();
            if ("__init__.py".equals(this.moduleName)) {
                --dotPrefixTokensSize;
            }
            int sizeLimit = Math.max(0, moduleFqnElements.size() - dotPrefixTokensSize);
            fromModuleFqn = Stream.concat(moduleFqnElements.stream().limit(sizeLimit), fromModuleFqn.stream()).toList();
        }
        return fromModuleFqn;
    }

    private void collectWildcardImportedSymbols(List<String> moduleFqn) {
        PythonType resolvedModuleType = this.projectLevelTypeTable.getModuleType(moduleFqn);
        if (resolvedModuleType instanceof ModuleType) {
            ModuleType moduleType = (ModuleType)resolvedModuleType;
            this.wildcardImportedTypes.putAll(moduleType.members());
        }
    }

    private static List<String> dottedNameToPartFqn(DottedName dottedName) {
        return dottedName.names().stream().map(Name::name).toList();
    }

    private void setTypeToImportFromStatement(ImportFrom importFrom, List<String> fqn) {
        PythonType module = this.projectLevelTypeTable.getModuleType(fqn);
        for (AliasedName aliasedName : importFrom.importedNames()) {
            aliasedName.dottedName().names().stream().findFirst().ifPresent(name -> {
                ArrayList<String> fullFqn = new ArrayList<String>(fqn);
                fullFqn.add(name.name());
                this.projectLevelTypeTable.getModuleType(fullFqn);
                PythonType type = module.resolveMember(name.name()).orElseGet(() -> TrivialTypeInferenceVisitor.createUnresolvedImportType(fqn, name));
                Name boundName = Optional.ofNullable(aliasedName.alias()).orElse((Name)name);
                TrivialTypeInferenceVisitor.setTypeToName(boundName, type);
            });
        }
        if (module instanceof ModuleType) {
            ModuleType moduleType = (ModuleType)module;
            Optional.ofNullable(importFrom.module()).map(importedDottedName -> importedDottedName.names().get(importedDottedName.names().size() - 1)).ifPresent(lastImportedModuleName -> TrivialTypeInferenceVisitor.setTypeToName(lastImportedModuleName, moduleType));
        }
    }

    private static UnknownType.UnresolvedImportType createUnresolvedImportType(List<String> moduleFqnList, Name name) {
        String fromModuleFqn = String.join((CharSequence)".", moduleFqnList);
        String fqn = fromModuleFqn.isEmpty() ? name.name() : String.join((CharSequence)".", fromModuleFqn, name.name());
        return new UnknownType.UnresolvedImportType(fqn);
    }

    @Override
    public void visitAssignmentStatement(AssignmentStatement assignmentStatement) {
        this.scan(assignmentStatement.assignedValue());
        this.scan(assignmentStatement.lhsExpressions());
        TrivialTypeInferenceVisitor.getFirstAssignmentName(assignmentStatement).ifPresent(lhsName -> {
            PythonType assignedValueType = assignmentStatement.assignedValue().typeV2();
            lhsName.typeV2(assignedValueType);
            this.addStaticFieldToClass((Name)lhsName, PythonType.UNKNOWN);
        });
    }

    @Override
    public void visitAnnotatedAssignment(AnnotatedAssignment assignmentStatement) {
        super.visitAnnotatedAssignment(assignmentStatement);
        Optional.ofNullable(assignmentStatement.variable()).filter(NameImpl.class::isInstance).map(NameImpl.class::cast).ifPresent(lhsName -> {
            if (this.currentType() instanceof ClassType) {
                Optional.ofNullable(assignmentStatement.annotation()).map(TypeAnnotation::expression).map(Expression::typeV2).filter(Predicate.not(PythonType.UNKNOWN::equals)).map(t -> new ObjectType((PythonType)t, TypeSource.TYPE_HINT)).ifPresent(lhsName::typeV2);
                this.addStaticFieldToClass((Name)lhsName, lhsName.typeV2());
            }
        });
    }

    @Override
    public void visitCallExpression(CallExpression callExpression) {
        super.visitCallExpression(callExpression);
        this.assignPossibleTypeVar(callExpression);
    }

    private void assignPossibleTypeVar(CallExpression callExpression) {
        PythonType pythonType = callExpression.callee().typeV2();
        TriBool check = this.typeChecker.typeCheckBuilder().isTypeWithName("typing.TypeVar").check(pythonType);
        if (check == TriBool.TRUE) {
            Tree parent = TreeUtils.firstAncestor(callExpression, t -> t.is(Tree.Kind.ASSIGNMENT_STMT, Tree.Kind.ANNOTATED_ASSIGNMENT, Tree.Kind.ASSIGNMENT_EXPRESSION));
            Optional<Object> assignedName = Optional.empty();
            if (parent instanceof AssignmentStatement) {
                AssignmentStatement assignmentStatement = (AssignmentStatement)parent;
                assignedName = TrivialTypeInferenceVisitor.extractAssignedName(assignmentStatement);
            }
            if (parent instanceof AnnotatedAssignment) {
                AnnotatedAssignment annotatedAssignment = (AnnotatedAssignment)parent;
                assignedName = TrivialTypeInferenceVisitor.extractAssignedName(annotatedAssignment);
            }
            if (parent instanceof AssignmentExpression) {
                AssignmentExpression assignmentExpression = (AssignmentExpression)parent;
                assignedName = TrivialTypeInferenceVisitor.extractAssignedName(assignmentExpression);
            }
            assignedName.ifPresent(name -> this.typeVarNames.add(name.name()));
        }
    }

    private static Optional<Name> extractAssignedName(AssignmentExpression assignmentExpression) {
        return Optional.of(assignmentExpression.lhsName()).map(Name.class::cast);
    }

    private static Optional<Name> extractAssignedName(AnnotatedAssignment annotatedAssignment) {
        return Optional.of(annotatedAssignment.variable()).filter(v -> v.is(Tree.Kind.NAME)).map(Name.class::cast);
    }

    private static Optional<Name> extractAssignedName(AssignmentStatement assignmentStatement) {
        return assignmentStatement.lhsExpressions().stream().findFirst().map(ExpressionList::expressions).stream().flatMap(Collection::stream).findFirst().filter(v -> v.is(Tree.Kind.NAME)).map(Name.class::cast);
    }

    private static Optional<NameImpl> getFirstAssignmentName(AssignmentStatement assignmentStatement) {
        return Optional.of(assignmentStatement).map(AssignmentStatement::lhsExpressions).filter(lhs -> lhs.size() == 1).map(lhs -> (ExpressionList)lhs.get(0)).map(ExpressionList::expressions).filter(lhs -> lhs.size() == 1).map(lhs -> (Expression)lhs.get(0)).filter(NameImpl.class::isInstance).map(NameImpl.class::cast);
    }

    private void addStaticFieldToClass(Name name, PythonType type) {
        PythonType pythonType = this.currentType();
        if (pythonType instanceof ClassType) {
            ClassType ownerClass = (ClassType)pythonType;
            String memberName = name.name();
            List<Member> toRemove = ownerClass.members().stream().filter(member -> memberName.equals(member.name())).toList();
            ownerClass.members().removeAll(toRemove);
            ownerClass.members().add(new Member(memberName, type));
        }
    }

    @Override
    public void visitParameter(Parameter parameter) {
        this.scan(parameter.typeAnnotation());
        this.scan(parameter.defaultValue());
        Optional.ofNullable(parameter.typeAnnotation()).map(TypeAnnotation::expression).map(TrivialTypeInferenceVisitor::resolveTypeAnnotationExpressionType).ifPresent(type -> TrivialTypeInferenceVisitor.setTypeToName(parameter.name(), type));
        this.scan(parameter.name());
    }

    private static PythonType resolveTypeAnnotationExpressionType(Expression expression) {
        SubscriptionExpression subscriptionExpression;
        Name name;
        if (expression instanceof Name && (name = (Name)expression).typeV2() != PythonType.UNKNOWN) {
            return new ObjectType(name.typeV2(), TypeSource.TYPE_HINT);
        }
        if (expression instanceof SubscriptionExpression && (subscriptionExpression = (SubscriptionExpression)expression).object().typeV2() != PythonType.UNKNOWN) {
            List<PythonType> candidateTypes = subscriptionExpression.subscripts().expressions().stream().map(Expression::typeV2).distinct().toList();
            PythonType elementsType = UnionType.or(candidateTypes);
            ArrayList<PythonType> attributes = new ArrayList<PythonType>();
            attributes.add(new ObjectType(elementsType, TypeSource.TYPE_HINT));
            return new ObjectType(subscriptionExpression.object().typeV2(), attributes, new ArrayList<Member>(), TypeSource.TYPE_HINT);
        }
        if (expression instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            PythonType left = TrivialTypeInferenceVisitor.resolveTypeAnnotationExpressionType(binaryExpression.leftOperand());
            PythonType right = TrivialTypeInferenceVisitor.resolveTypeAnnotationExpressionType(binaryExpression.rightOperand());
            return UnionType.or(left, right, new PythonType[0]);
        }
        PythonType pythonType = expression.typeV2();
        if (pythonType instanceof ClassType) {
            ClassType classType = (ClassType)pythonType;
            return new ObjectType(classType, TypeSource.TYPE_HINT);
        }
        return PythonType.UNKNOWN;
    }

    @Override
    public void visitQualifiedExpression(QualifiedExpression qualifiedExpression) {
        this.scan(qualifiedExpression.qualifier());
        Name name = qualifiedExpression.name();
        if (name instanceof NameImpl) {
            NameImpl name2 = (NameImpl)name;
            PythonType nameType = qualifiedExpression.qualifier().typeV2().resolveMember(qualifiedExpression.name().name()).orElse(PythonType.UNKNOWN);
            name2.typeV2(nameType);
        }
    }

    @Override
    public void visitSubscriptionExpression(SubscriptionExpression subscriptionExpression) {
        super.visitSubscriptionExpression(subscriptionExpression);
        PythonType pythonType = subscriptionExpression.object().typeV2();
        if (this.typeChecker.typeCheckBuilder().isGeneric().check(pythonType) == TriBool.TRUE) {
            ((SubscriptionExpressionImpl)subscriptionExpression).typeV2(pythonType);
        }
    }

    @Override
    public void visitName(Name name) {
        SymbolV2 symbolV2 = name.symbolV2();
        if (symbolV2 == null) {
            Optional<PythonType> builtInType = this.projectLevelTypeTable.getBuiltinsModule().resolveMember(name.name());
            if (builtInType.isPresent()) {
                TrivialTypeInferenceVisitor.setTypeToName(name, builtInType.get());
            } else {
                TypeWrapper wildcardImportedType = this.wildcardImportedTypes.get(name.name());
                if (wildcardImportedType != null) {
                    TrivialTypeInferenceVisitor.setTypeToName(name, wildcardImportedType.type());
                }
            }
            return;
        }
        ArrayList<UsageV2> bindingUsages = new ArrayList<UsageV2>();
        for (UsageV2 usage : symbolV2.usages()) {
            if (usage.kind().equals((Object)UsageV2.Kind.GLOBAL_DECLARATION)) {
                return;
            }
            if (usage.isBindingUsage()) {
                bindingUsages.add(usage);
            }
            if (bindingUsages.size() <= 1) continue;
            return;
        }
        bindingUsages.stream().findFirst().filter(UsageV2::isBindingUsage).map(UsageV2::tree).filter(Expression.class::isInstance).map(Expression.class::cast).map(Expression::typeV2).filter(TrivialTypeInferenceVisitor::shouldTypeBeEagerlyPropagated).ifPresent(type -> TrivialTypeInferenceVisitor.setTypeToName(name, type));
    }

    private static boolean shouldTypeBeEagerlyPropagated(PythonType t) {
        return t instanceof ClassType || t instanceof FunctionType || t instanceof ModuleType || t instanceof UnknownType.UnresolvedImportType || t instanceof SpecialFormType;
    }

    private PythonType currentType() {
        return this.typeStack.peek().type();
    }

    private String currentScopeFullyQualifiedName() {
        return this.typeStack.peek().scopeFullyQualifiedName();
    }

    private void inTypeScope(PythonType pythonType, Runnable runnable) {
        String newScopeFullyQualifiedName = Optional.ofNullable(this.typeStack.peek()).map(Scope::scopeFullyQualifiedName).map(s -> s + "." + pythonType.name()).orElse(this.fullyQualifiedModuleName);
        this.typeStack.push(new Scope(pythonType, newScopeFullyQualifiedName));
        runnable.run();
        this.typeStack.poll();
    }

    private static void setTypeToName(@Nullable Tree tree, @Nullable PythonType type) {
        if (tree instanceof NameImpl) {
            NameImpl name = (NameImpl)tree;
            if (type != null) {
                name.typeV2(type);
            }
        }
    }

    private record Scope(PythonType type, String scopeFullyQualifiedName) {
    }
}

