/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic.v2.types;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sonar.plugins.python.api.tree.AliasedName;
import org.sonar.plugins.python.api.tree.AnnotatedAssignment;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.CompoundAssignmentStatement;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ForStatement;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.ImportFrom;
import org.sonar.plugins.python.api.tree.ImportName;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Parameter;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.python.semantic.v2.SymbolV2;
import org.sonar.python.semantic.v2.types.Assignment;
import org.sonar.python.semantic.v2.types.Definition;
import org.sonar.python.semantic.v2.types.LoopAssignment;
import org.sonar.python.semantic.v2.types.ParameterDefinition;
import org.sonar.python.semantic.v2.types.Propagation;
import org.sonar.python.tree.NameImpl;

public class PropagationVisitor
extends BaseTreeVisitor {
    private final Map<SymbolV2, Set<Propagation>> propagationsByLhs = new HashMap<SymbolV2, Set<Propagation>>();
    private final Map<Statement, Assignment> assignmentsByAssignmentStatement = new HashMap<Statement, Assignment>();
    private final Map<Statement, Set<Definition>> definitionsByDefinitionStatement = new HashMap<Statement, Set<Definition>>();

    public Map<Statement, Assignment> assignmentsByAssignmentStatement() {
        return this.assignmentsByAssignmentStatement;
    }

    public Map<Statement, Set<Definition>> definitionsByDefinitionStatement() {
        return this.definitionsByDefinitionStatement;
    }

    public Map<SymbolV2, Set<Propagation>> propagationsByLhs() {
        return this.propagationsByLhs;
    }

    @Override
    public void visitFunctionDef(FunctionDef functionDef) {
        super.visitFunctionDef(functionDef);
        Name name = functionDef.name();
        SymbolV2 symbol = name.symbolV2();
        if (symbol == null) {
            return;
        }
        Definition definition = new Definition(symbol, name);
        this.definitionsByDefinitionStatement.computeIfAbsent(functionDef, k -> new HashSet()).add(definition);
        this.propagationsByLhs.computeIfAbsent(symbol, s -> new HashSet()).add(definition);
    }

    @Override
    public void visitClassDef(ClassDef classDef) {
        super.visitClassDef(classDef);
        Name name = classDef.name();
        SymbolV2 symbol = name.symbolV2();
        if (symbol == null) {
            return;
        }
        Definition definition = new Definition(symbol, name);
        this.definitionsByDefinitionStatement.computeIfAbsent(classDef, k -> new HashSet()).add(definition);
        this.propagationsByLhs.computeIfAbsent(symbol, s -> new HashSet()).add(definition);
    }

    @Override
    public void visitParameter(Parameter parameter) {
        Optional.ofNullable(parameter.name()).ifPresent(name -> {
            SymbolV2 symbol = name.symbolV2();
            ParameterDefinition parametedDefinition = new ParameterDefinition(symbol, (Name)name);
            this.propagationsByLhs.computeIfAbsent(symbol, s -> new HashSet()).add(parametedDefinition);
        });
    }

    @Override
    public void visitAssignmentStatement(AssignmentStatement assignmentStatement) {
        super.visitAssignmentStatement(assignmentStatement);
        if (assignmentStatement.lhsExpressions().stream().anyMatch(expressionList -> !expressionList.commas().isEmpty())) {
            return;
        }
        List lhsExpressions = assignmentStatement.lhsExpressions().stream().flatMap(exprList -> exprList.expressions().stream()).toList();
        if (lhsExpressions.size() != 1) {
            return;
        }
        this.processAssignment(assignmentStatement, (Expression)lhsExpressions.get(0), assignmentStatement.assignedValue());
    }

    @Override
    public void visitCompoundAssignment(CompoundAssignmentStatement compoundAssignment) {
        super.visitCompoundAssignment(compoundAssignment);
        this.processAssignment(compoundAssignment, compoundAssignment.lhsExpression(), compoundAssignment.rhsExpression());
    }

    @Override
    public void visitAnnotatedAssignment(AnnotatedAssignment annotatedAssignment) {
        super.visitAnnotatedAssignment(annotatedAssignment);
        Expression assignedValue = annotatedAssignment.assignedValue();
        if (assignedValue != null) {
            this.processAssignment(annotatedAssignment, annotatedAssignment.variable(), assignedValue);
        }
    }

    @Override
    public void visitImportName(ImportName importName) {
        super.visitImportName(importName);
        importName.modules().forEach(aliasedName -> this.propagateImportToAliasedName((AliasedName)aliasedName, importName));
    }

    @Override
    public void visitImportFrom(ImportFrom importFrom) {
        super.visitImportFrom(importFrom);
        importFrom.importedNames().forEach(aliasedName -> this.propagateImportToAliasedName((AliasedName)aliasedName, importFrom));
    }

    public void propagateImportToAliasedName(AliasedName aliasedName, Statement importName) {
        Name alias = aliasedName.alias();
        List<Name> names = alias == null ? aliasedName.dottedName().names() : List.of(alias);
        for (Name name : names) {
            this.propagateToName(importName, name);
        }
    }

    private void propagateToName(Statement importName, Name name) {
        SymbolV2 symbolV2 = name.symbolV2();
        if (symbolV2 != null) {
            Definition definition = new Definition(symbolV2, name);
            this.definitionsByDefinitionStatement.computeIfAbsent(importName, k -> new HashSet()).add(definition);
            this.propagationsByLhs.computeIfAbsent(symbolV2, s -> new HashSet()).add(definition);
        }
    }

    @Override
    public void visitForStatement(ForStatement forStatement) {
        this.scan(forStatement.testExpressions());
        if (forStatement.testExpressions().size() == 1 && forStatement.expressions().size() == 1) {
            forStatement.testExpressions().stream().findFirst().ifPresent(rhsExpression -> forStatement.expressions().stream().findFirst().filter(NameImpl.class::isInstance).map(NameImpl.class::cast).ifPresent(name -> {
                SymbolV2 symbol = name.symbolV2();
                LoopAssignment assignment = new LoopAssignment(symbol, (Name)name, (Expression)rhsExpression);
                this.assignmentsByAssignmentStatement.put(forStatement, assignment);
                this.propagationsByLhs.computeIfAbsent(symbol, s -> new HashSet()).add(assignment);
            }));
        }
        this.scan(forStatement.body());
        this.scan(forStatement.elseClause());
    }

    private void processAssignment(Statement assignmentStatement, Expression lhsExpression, Expression rhsExpression) {
        if (lhsExpression instanceof Name) {
            Name lhs = (Name)lhsExpression;
            SymbolV2 symbol = lhs.symbolV2();
            if (symbol == null) {
                return;
            }
            Assignment assignment = new Assignment(symbol, lhs, rhsExpression);
            this.assignmentsByAssignmentStatement.put(assignmentStatement, assignment);
            this.propagationsByLhs.computeIfAbsent(symbol, s -> new HashSet()).add(assignment);
        }
    }
}

