/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic.v2.types;

import java.util.HashSet;
import java.util.Set;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.python.semantic.v2.SymbolV2;
import org.sonar.python.tree.TreeUtils;

public abstract class Propagation {
    private final Set<SymbolV2> variableDependencies;
    private final Set<Propagation> dependents;
    private final SymbolV2 lhsSymbol;
    private final Name lhsName;

    protected Propagation(SymbolV2 lhsSymbol, Name lhsName) {
        this.lhsSymbol = lhsSymbol;
        this.lhsName = lhsName;
        this.variableDependencies = new HashSet<SymbolV2>();
        this.dependents = new HashSet<Propagation>();
    }

    Tree scopeTree(Name name) {
        return TreeUtils.firstAncestor(name, t -> t.is(Tree.Kind.FUNCDEF, Tree.Kind.FILE_INPUT, Tree.Kind.CLASSDEF));
    }

    boolean areDependenciesReady(Set<SymbolV2> initializedVars) {
        return initializedVars.containsAll(this.variableDependencies);
    }

    Set<Propagation> dependents() {
        return this.dependents;
    }

    public Name lhsName() {
        return this.lhsName;
    }

    public abstract PythonType rhsType();

    public SymbolV2 lhsSymbol() {
        return this.lhsSymbol;
    }

    public void addVariableDependency(SymbolV2 dependency) {
        this.variableDependencies.add(dependency);
    }

    public void addDependent(Propagation dependent) {
        this.dependents.add(dependent);
    }
}

