/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic.v2.types;

import java.util.Optional;
import java.util.Set;
import org.sonar.plugins.python.api.TriBool;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.types.v2.FunctionType;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.python.semantic.v2.SymbolV2;
import org.sonar.python.semantic.v2.types.TrivialTypePropagationVisitor;
import org.sonar.python.semantic.v2.types.TypeInferenceProgramState;
import org.sonar.python.semantic.v2.typetable.TypeTable;
import org.sonar.python.tree.NameImpl;
import org.sonar.python.types.v2.TypeCheckBuilder;
import org.sonar.python.types.v2.TypeUtils;

public class ProgramStateTypeInferenceVisitor
extends TrivialTypePropagationVisitor {
    private final TypeInferenceProgramState state;
    private final TypeCheckBuilder isPropertyTypeCheck;

    public ProgramStateTypeInferenceVisitor(TypeInferenceProgramState state, TypeTable typeTable) {
        super(typeTable);
        this.state = state;
        this.isPropertyTypeCheck = new TypeCheckBuilder(typeTable).isSubtypeOf("property");
    }

    @Override
    public void visitName(Name name) {
        Optional.ofNullable(name.symbolV2()).ifPresent(symbol -> {
            Set<PythonType> pythonTypes = this.state.getTypes((SymbolV2)symbol);
            if (!pythonTypes.isEmpty()) {
                ((NameImpl)name).typeV2(ProgramStateTypeInferenceVisitor.union(pythonTypes));
            }
        });
        super.visitName(name);
    }

    @Override
    public void visitFunctionDef(FunctionDef pyFunctionDefTree) {
    }

    @Override
    public void visitQualifiedExpression(QualifiedExpression qualifiedExpression) {
        this.scan(qualifiedExpression.qualifier());
        Name name = qualifiedExpression.name();
        if (name instanceof NameImpl) {
            NameImpl name2 = (NameImpl)name;
            Optional pythonType = Optional.of(qualifiedExpression.qualifier()).map(Expression::typeV2).flatMap(t -> t.resolveMember(name2.name()));
            if (pythonType.isPresent()) {
                FunctionType functionType;
                boolean isProperty;
                PythonType type = (PythonType)pythonType.get();
                if (type instanceof FunctionType && (isProperty = (functionType = (FunctionType)type).decorators().stream().anyMatch(t -> this.isPropertyTypeCheck.check(t.type()) == TriBool.TRUE))) {
                    type = functionType.returnType();
                }
                name2.typeV2(type);
            }
        }
    }

    private static PythonType union(Set<PythonType> types) {
        return types.stream().collect(TypeUtils.toUnionType());
    }
}

