/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic.v2.types;

import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.plugins.python.api.types.v2.TypeSource;
import org.sonar.plugins.python.api.types.v2.UnknownType;
import org.sonar.python.semantic.v2.SymbolV2;
import org.sonar.python.semantic.v2.types.TypeInferenceProgramState;
import org.sonar.python.semantic.v2.typetable.TypeTable;

public class IsInstanceVisitor
extends BaseTreeVisitor {
    private final PythonType isInstanceFunctionType;
    private TypeInferenceProgramState state;

    public IsInstanceVisitor(TypeTable projectLevelTypeTable) {
        this.isInstanceFunctionType = projectLevelTypeTable.getType("isinstance");
    }

    public void setState(TypeInferenceProgramState state) {
        this.state = state;
    }

    @Override
    public void visitCallExpression(CallExpression callExpression) {
        SymbolV2 firstArgumentSymbol;
        if (callExpression.callee().typeV2() == this.isInstanceFunctionType && callExpression.arguments().size() == 2 && (firstArgumentSymbol = this.getFirstArgumentSymbol(callExpression)) != null) {
            this.state.setTypes(firstArgumentSymbol, Set.of(PythonType.UNKNOWN));
        }
        super.visitCallExpression(callExpression);
    }

    @CheckForNull
    private SymbolV2 getFirstArgumentSymbol(CallExpression callExpression) {
        Name variableName;
        RegularArgument regularArgument;
        Expression expression;
        Argument argument = callExpression.arguments().get(0);
        if (argument instanceof RegularArgument && (expression = (regularArgument = (RegularArgument)argument).expression()) instanceof Name && this.state.getTypes((variableName = (Name)expression).symbolV2()).stream().anyMatch(type -> !(type instanceof UnknownType) && type.typeSource() == TypeSource.TYPE_HINT)) {
            return variableName.symbolV2();
        }
        return null;
    }
}

