/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic.v2.types;

import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sonar.plugins.python.api.cfg.ControlFlowGraph;
import org.sonar.plugins.python.api.tree.AnnotatedAssignment;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.CompoundAssignmentStatement;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ForStatement;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.ImportFrom;
import org.sonar.plugins.python.api.tree.ImportName;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Parameter;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.python.cfg.fixpoint.ForwardAnalysis;
import org.sonar.python.cfg.fixpoint.ProgramState;
import org.sonar.python.semantic.v2.SymbolV2;
import org.sonar.python.semantic.v2.types.Assignment;
import org.sonar.python.semantic.v2.types.Definition;
import org.sonar.python.semantic.v2.types.IsInstanceVisitor;
import org.sonar.python.semantic.v2.types.ProgramStateTypeInferenceVisitor;
import org.sonar.python.semantic.v2.types.TypeInferenceProgramState;
import org.sonar.python.semantic.v2.typetable.TypeTable;

public class FlowSensitiveTypeInference
extends ForwardAnalysis {
    private final Set<SymbolV2> trackedVars;
    private final Map<Statement, Assignment> assignmentsByAssignmentStatement;
    private final Map<Statement, Set<Definition>> definitionsByDefinitionStatement;
    private final Map<String, PythonType> parameterTypesByName;
    private final TypeTable typeTable;
    private final IsInstanceVisitor isInstanceVisitor;

    public FlowSensitiveTypeInference(TypeTable typeTable, Set<SymbolV2> trackedVars, Map<Statement, Assignment> assignmentsByAssignmentStatement, Map<Statement, Set<Definition>> definitionsByDefinitionStatement, Map<String, PythonType> parameterTypesByName) {
        this.trackedVars = trackedVars;
        this.assignmentsByAssignmentStatement = assignmentsByAssignmentStatement;
        this.definitionsByDefinitionStatement = definitionsByDefinitionStatement;
        this.parameterTypesByName = parameterTypesByName;
        this.typeTable = typeTable;
        this.isInstanceVisitor = new IsInstanceVisitor(typeTable);
    }

    @Override
    public ProgramState initialState() {
        TypeInferenceProgramState initialState = new TypeInferenceProgramState();
        for (SymbolV2 variable : this.trackedVars) {
            initialState.setTypes(variable, Set.of());
        }
        return initialState;
    }

    @Override
    public void updateProgramState(Tree element, ProgramState programState) {
        TypeInferenceProgramState state = (TypeInferenceProgramState)programState;
        if (element instanceof AssignmentStatement) {
            AssignmentStatement assignment = (AssignmentStatement)element;
            this.updateTree(assignment.assignedValue(), state);
            this.handleAssignment(assignment, state);
            assignment.lhsExpressions().forEach(lhs -> this.updateTree((Tree)lhs, state));
        } else if (element instanceof CompoundAssignmentStatement) {
            this.updateTree(element, state);
        } else if (element instanceof AnnotatedAssignment) {
            AnnotatedAssignment assignment = (AnnotatedAssignment)element;
            Expression assignedValue = assignment.assignedValue();
            if (assignedValue != null) {
                this.handleAssignment(assignment, state);
                this.updateTree(assignedValue, state);
                this.updateTree(assignment.variable(), state);
            }
        } else if (element instanceof FunctionDef) {
            FunctionDef functionDef = (FunctionDef)element;
            this.handleDefinitions(functionDef, state);
        } else if (element instanceof ClassDef) {
            ClassDef classDef = (ClassDef)element;
            this.handleDefinitions(classDef, state);
        } else if (element instanceof ImportName) {
            ImportName importName = (ImportName)element;
            this.handleDefinitions(importName, state);
        } else if (element instanceof ImportFrom) {
            ImportFrom importFrom = (ImportFrom)element;
            this.handleDefinitions(importFrom, state);
        } else if (element instanceof Parameter) {
            Parameter parameter = (Parameter)element;
            this.handleParameter(parameter, state);
        } else if (FlowSensitiveTypeInference.isForLoopAssignment(element)) {
            this.handleLoopAssignment(element, state);
        } else {
            this.isInstanceVisitor.setState(state);
            element.accept(this.isInstanceVisitor);
            this.updateTree(element, state);
        }
    }

    @Override
    public TypeInferenceProgramState compute(ControlFlowGraph cfg) {
        return (TypeInferenceProgramState)super.compute(cfg);
    }

    private void handleParameter(Parameter parameter, TypeInferenceProgramState state) {
        Name name = parameter.name();
        if (name == null || !this.trackedVars.contains(name.symbolV2())) {
            return;
        }
        SymbolV2 symbol = name.symbolV2();
        if (symbol == null) {
            return;
        }
        PythonType type = this.parameterTypesByName.getOrDefault(name.name(), PythonType.UNKNOWN);
        state.setTypes(symbol, new HashSet<PythonType>(Set.of(type)));
        this.updateTree(name, state);
    }

    private void updateTree(Tree tree, TypeInferenceProgramState state) {
        tree.accept(new ProgramStateTypeInferenceVisitor(state, this.typeTable));
    }

    private static boolean isForLoopAssignment(Tree tree) {
        ForStatement forStatement;
        Tree tree2;
        return tree instanceof Name && (tree2 = tree.parent()) instanceof ForStatement && (forStatement = (ForStatement)tree2).expressions().contains(tree);
    }

    private void handleLoopAssignment(Tree element, TypeInferenceProgramState state) {
        Optional.of(element).map(Tree::parent).filter(ForStatement.class::isInstance).map(ForStatement.class::cast).ifPresent(forStatement -> {
            forStatement.testExpressions().forEach(t -> this.updateTree((Tree)t, state));
            Optional.ofNullable(this.assignmentsByAssignmentStatement.get(forStatement)).filter(assignment -> this.trackedVars.contains(assignment.lhsSymbol())).ifPresent(assignment -> Optional.of(assignment).map(Assignment::rhsType).ifPresent(collectionItemType -> state.setTypes(assignment.lhsSymbol(), Set.of(collectionItemType))));
        });
    }

    private void handleAssignment(Statement assignmentStatement, TypeInferenceProgramState programState) {
        Optional.ofNullable(this.assignmentsByAssignmentStatement.get(assignmentStatement)).ifPresent(assignment -> {
            if (this.trackedVars.contains(assignment.lhsSymbol())) {
                Name rhsName;
                Expression rhs = assignment.rhs();
                if (rhs instanceof Name && this.trackedVars.contains((rhsName = (Name)rhs).symbolV2())) {
                    SymbolV2 rhsSymbol = rhsName.symbolV2();
                    programState.setTypes(assignment.lhsSymbol(), programState.getTypes(rhsSymbol));
                } else {
                    programState.setTypes(assignment.lhsSymbol(), Set.of(rhs.typeV2()));
                }
            }
        });
    }

    private void handleDefinitions(Statement definitionStatement, TypeInferenceProgramState programState) {
        Optional.ofNullable(this.definitionsByDefinitionStatement.get(definitionStatement)).ifPresent(definitions -> definitions.forEach(d -> {
            SymbolV2 symbol = d.lhsSymbol();
            if (this.trackedVars.contains(symbol)) {
                programState.setTypes(symbol, Set.of(d.lhsName().typeV2()));
            }
        }));
    }
}

