/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic.v2.types;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.plugins.python.api.types.v2.UnionType;
import org.sonar.python.semantic.v2.SymbolV2;
import org.sonar.python.semantic.v2.SymbolV2Utils;
import org.sonar.python.semantic.v2.UsageV2;
import org.sonar.python.semantic.v2.types.Assignment;
import org.sonar.python.semantic.v2.types.Propagation;
import org.sonar.python.semantic.v2.types.TrivialTypePropagationVisitor;
import org.sonar.python.semantic.v2.types.TypeDependenciesCalculator;
import org.sonar.python.semantic.v2.typetable.TypeTable;
import org.sonar.python.tree.NameImpl;
import org.sonar.python.tree.TreeUtils;

public class AstBasedTypeInference {
    private final Map<SymbolV2, Set<Propagation>> propagationsByLhs;
    private final Propagator propagator;
    private final TypeDependenciesCalculator typeDependenciesCalculator;

    public AstBasedTypeInference(Map<SymbolV2, Set<Propagation>> propagationsByLhs, TypeTable typeTable) {
        this.propagationsByLhs = propagationsByLhs;
        this.propagator = new Propagator(typeTable);
        this.typeDependenciesCalculator = new TypeDependenciesCalculator();
    }

    public Map<SymbolV2, Set<PythonType>> process(Set<SymbolV2> trackedVars) {
        this.computePropagationDependencies(trackedVars);
        HashSet<SymbolV2> initializedVars = new HashSet<SymbolV2>();
        Set<Propagation> propagations = this.getTrackedPropagation(trackedVars);
        this.applyPropagations(propagations, initializedVars, true);
        this.applyPropagations(propagations, initializedVars, false);
        return propagations.stream().collect(Collectors.groupingBy(Propagation::lhsSymbol, Collectors.mapping(Propagation::rhsType, Collectors.toSet())));
    }

    private void computePropagationDependencies(Set<SymbolV2> trackedVars) {
        this.propagationsByLhs.forEach((lhs, props) -> {
            if (trackedVars.contains(lhs)) {
                props.stream().filter(Assignment.class::isInstance).map(Assignment.class::cast).forEach(assignment -> this.computeDependencies((Assignment)assignment, trackedVars));
            }
        });
    }

    private void computeDependencies(Assignment assignment, Set<SymbolV2> trackedVars) {
        ArrayDeque<Expression> workList = new ArrayDeque<Expression>();
        workList.push(assignment.rhs());
        while (!workList.isEmpty()) {
            Expression e = (Expression)workList.pop();
            if (e instanceof Name) {
                Name name = (Name)e;
                SymbolV2 symbol = name.symbolV2();
                if (symbol == null || !trackedVars.contains(symbol)) continue;
                assignment.addVariableDependency(symbol);
                this.propagationsByLhs.get(symbol).forEach(propagation -> propagation.addDependent(assignment));
                continue;
            }
            if (!this.typeDependenciesCalculator.hasTypeDependencies(e)) continue;
            workList.addAll(this.typeDependenciesCalculator.getTypeDependencies(e));
        }
    }

    private Set<Propagation> getTrackedPropagation(Set<SymbolV2> trackedVars) {
        HashSet<Propagation> trackedPropagations = new HashSet<Propagation>();
        this.propagationsByLhs.forEach((lhs, propagations) -> {
            if (trackedVars.contains(lhs)) {
                trackedPropagations.addAll((Collection<Propagation>)propagations);
            }
        });
        return trackedPropagations;
    }

    private void applyPropagations(Set<Propagation> propagations, Set<SymbolV2> initializedVars, boolean checkDependenciesReadiness) {
        HashSet<Propagation> workSet = new HashSet<Propagation>(propagations);
        while (!workSet.isEmpty()) {
            boolean learnt;
            Iterator iterator = workSet.iterator();
            Propagation propagation = (Propagation)iterator.next();
            iterator.remove();
            if (checkDependenciesReadiness && !propagation.areDependenciesReady(initializedVars) || !(learnt = this.propagator.propagate(propagation, initializedVars))) continue;
            workSet.addAll(propagation.dependents());
        }
    }

    private record Propagator(TypeTable typeTable) {
        public boolean propagate(Propagation propagation, Set<SymbolV2> initializedVars) {
            PythonType rhsType = propagation.rhsType();
            Name lhsName = propagation.lhsName();
            SymbolV2 lhsSymbol = propagation.lhsSymbol();
            if (initializedVars.add(lhsSymbol)) {
                this.propagateTypeToUsages(propagation, rhsType);
                return true;
            }
            PythonType currentType = Propagator.currentType(lhsName);
            if (currentType == null) {
                return false;
            }
            PythonType newType = UnionType.or(rhsType, currentType, new PythonType[0]);
            this.propagateTypeToUsages(propagation, newType);
            return !newType.equals(currentType);
        }

        private void propagateTypeToUsages(Propagation propagation, PythonType newType) {
            Tree scopeTree = propagation.scopeTree(propagation.lhsName());
            Propagator.getSymbolNonDeclarationUsageTrees(propagation.lhsSymbol()).filter(NameImpl.class::isInstance).map(NameImpl.class::cast).filter(n -> this.isInSameScope(propagation, (Name)n, scopeTree)).forEach(n -> n.typeV2(newType));
            this.updateTree(propagation);
        }

        private void updateTree(Propagation propagation) {
            Tree scopeTree = propagation.scopeTree(propagation.lhsName());
            scopeTree.accept(new TrivialTypePropagationVisitor(this.typeTable));
        }

        @CheckForNull
        private static PythonType currentType(Name lhsName) {
            return Optional.ofNullable(lhsName.symbolV2()).stream().flatMap(Propagator::getSymbolNonDeclarationUsageTrees).flatMap(TreeUtils.toStreamInstanceOfMapper(Expression.class)).findFirst().map(Expression::typeV2).orElse(null);
        }

        private static Stream<Tree> getSymbolNonDeclarationUsageTrees(SymbolV2 symbol) {
            return symbol.usages().stream().filter(u -> !SymbolV2Utils.isDeclaration(u)).map(UsageV2::tree);
        }

        private boolean isInSameScope(Propagation propagation, Name n, Tree scopeTree) {
            return Optional.ofNullable(propagation.scopeTree(n)).filter(scopeTree::equals).isPresent();
        }
    }
}

