/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic.v2.converter;

import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.python.index.TypeAnnotationDescriptor;
import org.sonar.python.semantic.v2.converter.ConversionContext;
import org.sonar.python.types.v2.LazyUnionType;

public class TypeAnnotationToPythonTypeConverter {
    private static final Set<String> EXCLUDING_TYPE_VAR_FQN_PATTERNS = Set.of("object", "^builtins\\.object$", "^_ctypes\\._CanCastTo$");

    public PythonType convert(ConversionContext context, TypeAnnotationDescriptor type) {
        switch (type.kind()) {
            case INSTANCE: {
                String fullyQualifiedName = type.fullyQualifiedName();
                if (fullyQualifiedName == null) {
                    return PythonType.UNKNOWN;
                }
                if ("typing._SpecialForm".equals(fullyQualifiedName)) {
                    return PythonType.UNKNOWN;
                }
                return fullyQualifiedName.isEmpty() ? PythonType.UNKNOWN : context.lazyTypesContext().getOrCreateLazyType(fullyQualifiedName);
            }
            case TYPE: {
                return context.lazyTypesContext().getOrCreateLazyType("type");
            }
            case TYPE_ALIAS: {
                return this.convert(context, type.args().get(0));
            }
            case CALLABLE: {
                return context.lazyTypesContext().getOrCreateLazyType("function");
            }
            case UNION: {
                return new LazyUnionType(type.args().stream().map(t -> this.convert(context, (TypeAnnotationDescriptor)t)).collect(Collectors.toSet()));
            }
            case TUPLE: {
                return context.lazyTypesContext().getOrCreateLazyType("tuple");
            }
            case NONE: {
                return context.lazyTypesContext().getOrCreateLazyType("NoneType");
            }
            case TYPED_DICT: {
                return context.lazyTypesContext().getOrCreateLazyType("dict");
            }
            case TYPE_VAR: {
                return Optional.of(type).filter(TypeAnnotationToPythonTypeConverter::filterTypeVar).map(TypeAnnotationDescriptor::fullyQualifiedName).map(context.lazyTypesContext()::getOrCreateLazyType).map(PythonType.class::cast).orElse(PythonType.UNKNOWN);
            }
        }
        return PythonType.UNKNOWN;
    }

    public static boolean filterTypeVar(TypeAnnotationDescriptor type) {
        return Optional.of(type).filter(Predicate.not(t -> t.prettyPrintedName().endsWith(".Self"))).map(TypeAnnotationDescriptor::fullyQualifiedName).filter(Predicate.not(String::isEmpty)).filter(fqn -> EXCLUDING_TYPE_VAR_FQN_PATTERNS.stream().noneMatch(fqn::matches)).isPresent();
    }
}

