/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic.v2.converter;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import org.sonar.plugins.python.api.types.v2.ClassType;
import org.sonar.plugins.python.api.types.v2.FunctionType;
import org.sonar.plugins.python.api.types.v2.ObjectType;
import org.sonar.plugins.python.api.types.v2.ParameterV2;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.plugins.python.api.types.v2.TypeWrapper;
import org.sonar.plugins.python.api.types.v2.UnionType;
import org.sonar.plugins.python.api.types.v2.UnknownType;
import org.sonar.python.index.AmbiguousDescriptor;
import org.sonar.python.index.ClassDescriptor;
import org.sonar.python.index.Descriptor;
import org.sonar.python.index.FunctionDescriptor;
import org.sonar.python.index.VariableDescriptor;
import org.sonar.python.semantic.v2.SymbolV2;
import org.sonar.python.semantic.v2.UsageV2;

public class PythonTypeToDescriptorConverter {
    public Descriptor convert(String moduleFqn, SymbolV2 symbol, Set<PythonType> types) {
        Set<Descriptor> candidates = types.stream().map(type -> PythonTypeToDescriptorConverter.convert(moduleFqn, moduleFqn, symbol.name(), type, symbol.usages())).flatMap(candidate -> {
            if (candidate instanceof AmbiguousDescriptor) {
                AmbiguousDescriptor ambiguousDescriptor = (AmbiguousDescriptor)candidate;
                return ambiguousDescriptor.alternatives().stream();
            }
            return Stream.of(candidate);
        }).collect(Collectors.toSet());
        if (candidates.size() == 1) {
            return (Descriptor)candidates.iterator().next();
        }
        if (candidates.size() > 1) {
            return new AmbiguousDescriptor(symbol.name(), PythonTypeToDescriptorConverter.symbolFqn(moduleFqn, symbol.name()), candidates);
        }
        throw new IllegalStateException("No candidate found for descriptor " + symbol.name());
    }

    private static Descriptor convert(String moduleFqn, String parentFqn, String symbolName, PythonType type, List<UsageV2> symbolUsages) {
        if (type instanceof FunctionType) {
            FunctionType functionType = (FunctionType)type;
            if (PythonTypeToDescriptorConverter.usagesContainAssignment(symbolUsages)) {
                return new VariableDescriptor(symbolName, PythonTypeToDescriptorConverter.symbolFqn(parentFqn, symbolName), null);
            }
            return PythonTypeToDescriptorConverter.convert(moduleFqn, functionType);
        }
        if (type instanceof ClassType) {
            ClassType classType = (ClassType)type;
            return PythonTypeToDescriptorConverter.convert(moduleFqn, parentFqn, symbolName, classType);
        }
        if (type instanceof UnionType) {
            UnionType unionType = (UnionType)type;
            return PythonTypeToDescriptorConverter.convert(moduleFqn, parentFqn, symbolName, unionType);
        }
        if (type instanceof UnknownType.UnresolvedImportType) {
            UnknownType.UnresolvedImportType unresolvedImportType = (UnknownType.UnresolvedImportType)type;
            return PythonTypeToDescriptorConverter.convert(parentFqn, symbolName, unresolvedImportType);
        }
        if (type instanceof ObjectType) {
            ObjectType objectType = (ObjectType)type;
            if (!moduleFqn.equals(parentFqn)) {
                return PythonTypeToDescriptorConverter.convert(moduleFqn, parentFqn, symbolName, objectType);
            }
        }
        return new VariableDescriptor(symbolName, PythonTypeToDescriptorConverter.symbolFqn(parentFqn, symbolName), null);
    }

    private static Descriptor convert(String moduleFqn, String parentFqn, String symbolName, ObjectType objectType) {
        return new VariableDescriptor(symbolName, PythonTypeToDescriptorConverter.symbolFqn(parentFqn, symbolName), PythonTypeToDescriptorConverter.typeFqn(moduleFqn, objectType.unwrappedType()));
    }

    private static Descriptor convert(String moduleFqn, FunctionType type) {
        List<FunctionDescriptor.Parameter> parameters = type.parameters().stream().map(parameter -> PythonTypeToDescriptorConverter.convert(moduleFqn, parameter)).toList();
        List<String> decorators = type.decorators().stream().map(TypeWrapper::type).map(decorator -> PythonTypeToDescriptorConverter.typeFqn(moduleFqn, decorator)).filter(Objects::nonNull).toList();
        return new FunctionDescriptor(type.name(), type.fullyQualifiedName(), parameters, type.isAsynchronous(), type.isInstanceMethod(), decorators, type.hasDecorators(), type.definitionLocation().orElse(null), null, null);
    }

    private static Descriptor convert(String moduleFqn, String parentFqn, String symbolName, ClassType type) {
        String symbolFqn = PythonTypeToDescriptorConverter.symbolFqn(parentFqn, symbolName);
        Set<Descriptor> memberDescriptors = type.members().stream().map(m -> PythonTypeToDescriptorConverter.convert(moduleFqn, symbolFqn, m.name(), m.type(), List.of())).collect(Collectors.toSet());
        boolean hasSuperClassWithoutDescriptor = false;
        ArrayList<String> superClasses = new ArrayList<String>();
        for (TypeWrapper superClassWrapper : type.superClasses()) {
            String superClassFqn = PythonTypeToDescriptorConverter.typeFqn(moduleFqn, superClassWrapper.type());
            if (superClassFqn != null) {
                superClasses.add(superClassFqn);
                continue;
            }
            hasSuperClassWithoutDescriptor = true;
        }
        String metaclassFQN = type.metaClasses().stream().map(metaClass -> PythonTypeToDescriptorConverter.typeFqn(moduleFqn, metaClass)).filter(Objects::nonNull).findFirst().orElse(null);
        return new ClassDescriptor(symbolName, symbolFqn, superClasses, memberDescriptors, type.hasDecorators(), type.definitionLocation().orElse(null), hasSuperClassWithoutDescriptor, type.hasMetaClass(), metaclassFQN, type.isGeneric());
    }

    private static Descriptor convert(String moduleFqn, String parentFqn, String symbolName, UnionType type) {
        Set<Descriptor> candidates = type.candidates().stream().map(candidateType -> PythonTypeToDescriptorConverter.convert(moduleFqn, parentFqn, symbolName, candidateType, List.of())).collect(Collectors.toSet());
        return new AmbiguousDescriptor(symbolName, PythonTypeToDescriptorConverter.symbolFqn(moduleFqn, symbolName), candidates);
    }

    private static Descriptor convert(String parentFqn, String symbolName, UnknownType.UnresolvedImportType type) {
        return new VariableDescriptor(symbolName, PythonTypeToDescriptorConverter.symbolFqn(parentFqn, symbolName), type.importPath());
    }

    private static FunctionDescriptor.Parameter convert(String moduleFqn, ParameterV2 parameter) {
        PythonType type = parameter.declaredType().type().unwrappedType();
        String annotatedType = PythonTypeToDescriptorConverter.typeFqn(moduleFqn, type);
        return new FunctionDescriptor.Parameter(parameter.name(), annotatedType, parameter.hasDefaultValue(), parameter.isKeywordOnly(), parameter.isPositionalOnly(), parameter.isPositionalVariadic(), parameter.isKeywordVariadic(), parameter.location());
    }

    @CheckForNull
    private static String typeFqn(String moduleFqn, PythonType type) {
        if (type instanceof UnknownType.UnresolvedImportType) {
            UnknownType.UnresolvedImportType importType = (UnknownType.UnresolvedImportType)type;
            return importType.importPath();
        }
        if (type instanceof ClassType) {
            ClassType classType = (ClassType)type;
            return classType.fullyQualifiedName();
        }
        if (type instanceof FunctionType) {
            FunctionType functionType = (FunctionType)type;
            return functionType.fullyQualifiedName();
        }
        return null;
    }

    private static String symbolFqn(String moduleFqn, String symbolName) {
        return moduleFqn + "." + symbolName;
    }

    private static boolean usagesContainAssignment(List<UsageV2> symbolUsages) {
        return symbolUsages.stream().anyMatch(u -> u.kind().equals((Object)UsageV2.Kind.ASSIGNMENT_LHS));
    }
}

