/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic.v2.converter;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.sonar.plugins.python.api.types.v2.ParameterV2;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.plugins.python.api.types.v2.TypeOrigin;
import org.sonar.plugins.python.api.types.v2.TypeWrapper;
import org.sonar.python.index.Descriptor;
import org.sonar.python.index.FunctionDescriptor;
import org.sonar.python.index.TypeAnnotationDescriptor;
import org.sonar.python.semantic.v2.FunctionTypeBuilder;
import org.sonar.python.semantic.v2.converter.ConversionContext;
import org.sonar.python.semantic.v2.converter.DescriptorToPythonTypeConverter;
import org.sonar.python.semantic.v2.converter.ParameterConverter;
import org.sonar.python.semantic.v2.converter.TypeAnnotationToPythonTypeConverter;
import org.sonar.python.types.v2.TypeUtils;

public class FunctionDescriptorToPythonTypeConverter
implements DescriptorToPythonTypeConverter {
    private final ParameterConverter parameterConverter = new ParameterConverter();
    private final TypeAnnotationToPythonTypeConverter typeAnnotationConverter = new TypeAnnotationToPythonTypeConverter();

    public PythonType convert(ConversionContext ctx, FunctionDescriptor from) {
        List<ParameterV2> parameters = from.parameters().stream().map(parameter -> this.parameterConverter.convert(ctx, (FunctionDescriptor.Parameter)parameter)).toList();
        PythonType returnType = Optional.ofNullable(from.typeAnnotationDescriptor()).map(typeAnnotation -> this.typeAnnotationConverter.convert(ctx, (TypeAnnotationDescriptor)typeAnnotation)).map(TypeUtils::ensureWrappedObjectType).orElse(PythonType.UNKNOWN);
        List<TypeWrapper> decorators = from.decorators().stream().filter(Objects::nonNull).map(ctx.lazyTypesContext()::getOrCreateLazyType).map(TypeWrapper::of).toList();
        TypeOrigin typeOrigin = ctx.typeOrigin();
        boolean hasVariadicParameter = FunctionDescriptorToPythonTypeConverter.hasVariadicParameter(parameters);
        FunctionTypeBuilder toBuilder = new FunctionTypeBuilder().withOwner(ctx.currentParent()).withName(from.name()).withFullyQualifiedName(from.fullyQualifiedName()).withParameters(parameters).withDecorators(decorators).withReturnType(returnType).withTypeOrigin(typeOrigin).withAsynchronous(from.isAsynchronous()).withHasDecorators(from.hasDecorators()).withInstanceMethod(from.isInstanceMethod()).withHasVariadicParameter(hasVariadicParameter).withDefinitionLocation(from.definitionLocation());
        return toBuilder.build();
    }

    private static boolean hasVariadicParameter(List<ParameterV2> parameters) {
        return parameters.stream().anyMatch(p -> p.isKeywordVariadic() || p.isPositionalVariadic());
    }

    @Override
    public PythonType convert(ConversionContext ctx, Descriptor from) {
        if (from instanceof FunctionDescriptor) {
            FunctionDescriptor functionDescriptor = (FunctionDescriptor)from;
            return this.convert(ctx, functionDescriptor);
        }
        throw new IllegalArgumentException("Unsupported Descriptor");
    }
}

