/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic.v2.converter;

import java.util.ArrayDeque;
import java.util.Deque;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.plugins.python.api.types.v2.TypeOrigin;
import org.sonar.python.index.Descriptor;
import org.sonar.python.semantic.v2.LazyTypesContext;
import org.sonar.python.semantic.v2.converter.DescriptorToPythonTypeConverter;

public class ConversionContext {
    private final String moduleFqn;
    private final LazyTypesContext lazyTypesContext;
    private final DescriptorToPythonTypeConverter converter;
    private final Deque<PythonType> parents;
    private final TypeOrigin typeOrigin;

    public ConversionContext(String moduleFqn, LazyTypesContext lazyTypesContext, DescriptorToPythonTypeConverter converter, TypeOrigin typeOrigin) {
        this.moduleFqn = moduleFqn;
        this.lazyTypesContext = lazyTypesContext;
        this.converter = converter;
        this.parents = new ArrayDeque<PythonType>();
        this.typeOrigin = typeOrigin;
    }

    public LazyTypesContext lazyTypesContext() {
        return this.lazyTypesContext;
    }

    public TypeOrigin typeOrigin() {
        return this.typeOrigin;
    }

    public PythonType convert(Descriptor from) {
        return this.converter.convert(this, from);
    }

    public void pushParent(PythonType pythonType) {
        this.parents.push(pythonType);
    }

    public PythonType currentParent() {
        return this.parents.peek();
    }

    public PythonType pollParent() {
        return this.parents.poll();
    }

    public String moduleFqn() {
        return this.moduleFqn;
    }
}

