/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic.v2.converter;

import org.sonar.plugins.python.api.types.v2.ClassType;
import org.sonar.plugins.python.api.types.v2.Member;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.plugins.python.api.types.v2.TypeWrapper;
import org.sonar.python.index.ClassDescriptor;
import org.sonar.python.index.Descriptor;
import org.sonar.python.semantic.v2.ClassTypeBuilder;
import org.sonar.python.semantic.v2.converter.ConversionContext;
import org.sonar.python.semantic.v2.converter.DescriptorToPythonTypeConverter;

public class ClassDescriptorToPythonTypeConverter
implements DescriptorToPythonTypeConverter {
    private static PythonType convert(ConversionContext ctx, ClassDescriptor from) {
        ClassTypeBuilder typeBuilder = new ClassTypeBuilder(from.name(), from.fullyQualifiedName()).withIsGeneric(from.supportsGenerics()).withDefinitionLocation(from.definitionLocation());
        from.superClasses().stream().map(fqn -> {
            if (fqn != null) {
                return ctx.lazyTypesContext().getOrCreateLazyType((String)fqn);
            }
            return PythonType.UNKNOWN;
        }).map(TypeWrapper::of).forEach(typeBuilder::addSuperClass);
        ClassType type = typeBuilder.build();
        ctx.pushParent(type);
        from.members().stream().map(d -> new Member(d.name(), ctx.convert((Descriptor)d))).forEach(type.members()::add);
        ctx.pollParent();
        return type;
    }

    @Override
    public PythonType convert(ConversionContext ctx, Descriptor from) {
        if (from instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor = (ClassDescriptor)from;
            return ClassDescriptorToPythonTypeConverter.convert(ctx, classDescriptor);
        }
        throw new IllegalArgumentException("Unsupported Descriptor");
    }
}

