/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic.v2.converter;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.plugins.python.api.types.v2.TypeOrigin;
import org.sonar.plugins.python.api.types.v2.TypeWrapper;
import org.sonar.python.index.Descriptor;
import org.sonar.python.semantic.v2.LazyTypesContext;
import org.sonar.python.semantic.v2.converter.AliasDescriptorToPythonTypeConverter;
import org.sonar.python.semantic.v2.converter.AmbiguousDescriptorToPythonTypeConverter;
import org.sonar.python.semantic.v2.converter.ClassDescriptorToPythonTypeConverter;
import org.sonar.python.semantic.v2.converter.ConversionContext;
import org.sonar.python.semantic.v2.converter.DescriptorToPythonTypeConverter;
import org.sonar.python.semantic.v2.converter.FunctionDescriptorToPythonTypeConverter;
import org.sonar.python.semantic.v2.converter.UnknownDescriptorToPythonTypeConverter;
import org.sonar.python.semantic.v2.converter.VariableDescriptorToPythonTypeConverter;

public class AnyDescriptorToPythonTypeConverter {
    private static final DescriptorToPythonTypeConverter UNKNOWN_DESCRIPTOR_CONVERTER = new UnknownDescriptorToPythonTypeConverter();
    private final Map<Descriptor.Kind, DescriptorToPythonTypeConverter> converters;
    private final LazyTypesContext lazyTypesContext;

    public AnyDescriptorToPythonTypeConverter(LazyTypesContext lazyTypesContext) {
        this.lazyTypesContext = lazyTypesContext;
        this.converters = new EnumMap<Descriptor.Kind, AliasDescriptorToPythonTypeConverter>(Map.of(Descriptor.Kind.CLASS, new ClassDescriptorToPythonTypeConverter(), Descriptor.Kind.FUNCTION, new FunctionDescriptorToPythonTypeConverter(), Descriptor.Kind.VARIABLE, new VariableDescriptorToPythonTypeConverter(), Descriptor.Kind.AMBIGUOUS, new AmbiguousDescriptorToPythonTypeConverter(), Descriptor.Kind.ALIAS, new AliasDescriptorToPythonTypeConverter()));
    }

    public Map<String, TypeWrapper> convertModuleType(String moduleFqn, Map<String, Descriptor> stringDescriptorMap) {
        HashMap<String, TypeWrapper> moduleMembers = new HashMap<String, TypeWrapper>();
        for (Map.Entry<String, Descriptor> entry : stringDescriptorMap.entrySet()) {
            Descriptor descriptor = entry.getValue();
            String name = entry.getKey();
            String fullyQualifiedName = descriptor.fullyQualifiedName();
            String reconstructedFqn = moduleFqn + "." + descriptor.name();
            PythonType result = !reconstructedFqn.equals(fullyQualifiedName) && fullyQualifiedName != null ? this.lazyTypesContext.getOrCreateLazyType(fullyQualifiedName) : this.convert(moduleFqn, descriptor, TypeOrigin.STUB);
            moduleMembers.put(name, TypeWrapper.of(result));
        }
        return moduleMembers;
    }

    public PythonType convert(String moduleFqn, Descriptor from, TypeOrigin typeOrigin) {
        ConversionContext ctx = new ConversionContext(moduleFqn, this.lazyTypesContext, this::convert, typeOrigin);
        return this.convert(ctx, from);
    }

    private PythonType convert(ConversionContext ctx, Descriptor from) {
        return this.converterFor(from).convert(ctx, from);
    }

    private DescriptorToPythonTypeConverter converterFor(Descriptor descriptor) {
        return this.converters.getOrDefault((Object)descriptor.kind(), UNKNOWN_DESCRIPTOR_CONVERTER);
    }
}

