/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic.v2.callgraph;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.function.Predicate;
import org.sonar.plugins.python.api.TriBool;
import org.sonar.python.semantic.v2.callgraph.CallGraph;
import org.sonar.python.semantic.v2.callgraph.CallGraphNode;

public class CallGraphWalker {
    private static final int DEFAULT_MAX_VISITED = 30;
    private final int maxVisited;
    private final CallGraph callGraph;

    public CallGraphWalker(CallGraph callGraph, int maxVisited) {
        this.callGraph = callGraph;
        this.maxVisited = maxVisited;
    }

    public CallGraphWalker(CallGraph callGraph) {
        this(callGraph, 30);
    }

    public TriBool isUsedFrom(String startFqn, Predicate<CallGraphNode> predicate) {
        ArrayDeque<CallGraphNode> queue = new ArrayDeque<CallGraphNode>();
        HashSet<String> visited = new HashSet<String>();
        queue.addAll(this.callGraph.getUsages(startFqn));
        while (!queue.isEmpty() && visited.size() <= this.maxVisited) {
            CallGraphNode current = (CallGraphNode)queue.pop();
            if (visited.contains(current.fqn())) continue;
            if (predicate.test(current)) {
                return TriBool.TRUE;
            }
            visited.add(current.fqn());
            queue.addAll(this.callGraph.getUsages(current.fqn()));
        }
        if (queue.isEmpty()) {
            return TriBool.FALSE;
        }
        return TriBool.UNKNOWN;
    }
}

