/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic.v2.callgraph;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.v2.FunctionType;
import org.sonar.plugins.python.api.types.v2.ModuleType;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.plugins.python.api.types.v2.UnionType;
import org.sonar.plugins.python.api.types.v2.UnknownType;
import org.sonar.python.semantic.v2.callgraph.CallGraph;
import org.sonar.python.tree.TreeUtils;

public class CallGraphCollector {
    private CallGraphCollector() {
    }

    public static CallGraph collectCallGraph(FileInput rootTree) {
        Visitor visitor = new Visitor();
        rootTree.accept(visitor);
        return visitor.build();
    }

    private static Optional<String> getFqn(PythonType type) {
        if (type instanceof FunctionType) {
            FunctionType functionType = (FunctionType)type;
            return Optional.of(functionType.fullyQualifiedName());
        }
        if (type instanceof ModuleType) {
            ModuleType moduleType = (ModuleType)type;
            return Optional.of(moduleType.fullyQualifiedName());
        }
        if (type instanceof UnknownType.UnresolvedImportType) {
            UnknownType.UnresolvedImportType unresolvedImportType = (UnknownType.UnresolvedImportType)type;
            return Optional.of(unresolvedImportType.importPath());
        }
        if (type instanceof UnionType) {
            UnionType unionType = (UnionType)type;
            Set unionFqnSet = unionType.candidates().stream().flatMap(candidate -> CallGraphCollector.getFqn(candidate).stream()).collect(Collectors.toSet());
            if (unionFqnSet.size() == 1) {
                return unionFqnSet.stream().findFirst();
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static class Visitor
    extends BaseTreeVisitor {
        private final CallGraph.Builder callGraphBuilder = new CallGraph.Builder();

        private Visitor() {
        }

        @Override
        public void visitCallExpression(CallExpression callExpr) {
            super.visitCallExpression(callExpr);
            Visitor.getCalledFunctionFqn(callExpr).ifPresent(calledFunctionFqn -> Visitor.getEnclosedFunctionFqn(callExpr).ifPresent(enclosedFunctionFqn -> this.callGraphBuilder.addUsage((String)enclosedFunctionFqn, (String)calledFunctionFqn)));
        }

        private static Optional<String> getCalledFunctionFqn(CallExpression callExpr) {
            PythonType calleeType = callExpr.callee().typeV2();
            return CallGraphCollector.getFqn(calleeType);
        }

        private static Optional<String> getEnclosedFunctionFqn(CallExpression callExpr) {
            Tree enclosingFuncDefTree = TreeUtils.firstAncestorOfKind(callExpr, Tree.Kind.FUNCDEF, Tree.Kind.LAMBDA);
            if (enclosingFuncDefTree instanceof FunctionDef) {
                FunctionDef enclosingFunctionDef = (FunctionDef)enclosingFuncDefTree;
                return CallGraphCollector.getFqn(enclosingFunctionDef.name().typeV2());
            }
            return Optional.empty();
        }

        public CallGraph build() {
            return this.callGraphBuilder.build();
        }
    }
}

