/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic.v2.callgraph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonar.python.semantic.v2.callgraph.CallGraphNode;

public class CallGraph {
    public static final CallGraph EMPTY = new CallGraph(Map.of());
    private final Map<String, List<CallGraphNode>> usageEdges;

    private CallGraph(Map<String, List<CallGraphNode>> usageEdges) {
        this.usageEdges = usageEdges;
    }

    public List<CallGraphNode> getUsages(String fqn) {
        return Collections.unmodifiableList(this.usageEdges.getOrDefault(fqn, List.of()));
    }

    public static class Builder {
        private Map<String, List<CallGraphNode>> builderUsageEdges = new HashMap<String, List<CallGraphNode>>();

        public Builder addUsage(String from, String to) {
            CallGraphNode node = new CallGraphNode(from);
            this.builderUsageEdges.computeIfAbsent(to, k -> new ArrayList()).add(node);
            return this;
        }

        public CallGraph build() {
            CallGraph graph = new CallGraph(this.builderUsageEdges);
            this.builderUsageEdges = new HashMap<String, List<CallGraphNode>>();
            return graph;
        }
    }
}

