/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic.v2;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.tree.AliasedName;
import org.sonar.plugins.python.api.tree.AnnotatedAssignment;
import org.sonar.plugins.python.api.tree.AnyParameter;
import org.sonar.plugins.python.api.tree.AssignmentExpression;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.CapturePattern;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.CompoundAssignmentStatement;
import org.sonar.plugins.python.api.tree.ComprehensionExpression;
import org.sonar.plugins.python.api.tree.ComprehensionFor;
import org.sonar.plugins.python.api.tree.Decorator;
import org.sonar.plugins.python.api.tree.DictCompExpression;
import org.sonar.plugins.python.api.tree.DottedName;
import org.sonar.plugins.python.api.tree.ExceptClause;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.ForStatement;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.FunctionLike;
import org.sonar.plugins.python.api.tree.GlobalStatement;
import org.sonar.plugins.python.api.tree.ImportFrom;
import org.sonar.plugins.python.api.tree.ImportName;
import org.sonar.plugins.python.api.tree.LambdaExpression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.NonlocalStatement;
import org.sonar.plugins.python.api.tree.Parameter;
import org.sonar.plugins.python.api.tree.ParameterList;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TupleParameter;
import org.sonar.plugins.python.api.tree.TypeAliasStatement;
import org.sonar.plugins.python.api.tree.TypeParams;
import org.sonar.plugins.python.api.tree.WithItem;
import org.sonar.python.semantic.SymbolUtils;
import org.sonar.python.semantic.v2.ScopeV2;
import org.sonar.python.semantic.v2.ScopeVisitor;
import org.sonar.python.semantic.v2.UsageV2;

public class WriteUsagesVisitor
extends ScopeVisitor {
    private ScopeV2 moduleScope;

    public WriteUsagesVisitor(Map<Tree, ScopeV2> scopesByRootTree) {
        super(scopesByRootTree);
    }

    @Override
    public void visitFileInput(FileInput tree) {
        this.createAndEnterScope(tree, null);
        this.moduleScope = this.currentScope();
        super.visitFileInput(tree);
    }

    @Override
    public void visitLambda(LambdaExpression lambdaExpression) {
        this.createAndEnterScope(lambdaExpression, this.currentScope());
        this.createParameters(lambdaExpression);
        super.visitLambda(lambdaExpression);
        this.leaveScope();
    }

    @Override
    public void visitDictCompExpression(DictCompExpression tree) {
        this.createAndEnterScope(tree, this.currentScope());
        super.visitDictCompExpression(tree);
        this.leaveScope();
    }

    @Override
    public void visitDecorator(Decorator tree) {
        this.leaveScope();
        super.visitDecorator(tree);
        this.enterScope(tree.parent());
    }

    @Override
    public void visitPyListOrSetCompExpression(ComprehensionExpression tree) {
        this.createAndEnterScope(tree, this.currentScope());
        super.visitPyListOrSetCompExpression(tree);
        this.leaveScope();
    }

    @Override
    public void visitFunctionDef(FunctionDef functionDef) {
        this.currentScope().addBindingUsage(functionDef.name(), UsageV2.Kind.FUNC_DECLARATION);
        this.createAndEnterScope(functionDef, this.currentScope());
        this.createTypeParameters(functionDef.typeParams());
        this.createParameters(functionDef);
        super.visitFunctionDef(functionDef);
        this.leaveScope();
    }

    private void createTypeParameters(@Nullable TypeParams typeParams) {
        Optional.ofNullable(typeParams).map(TypeParams::typeParamsList).stream().flatMap(Collection::stream).forEach(typeParam -> this.currentScope().addBindingUsage(typeParam.name(), UsageV2.Kind.TYPE_PARAM_DECLARATION));
    }

    private void createParameters(FunctionLike function) {
        AnyParameter first;
        ParameterList parameterList = function.parameters();
        if (parameterList == null || parameterList.all().isEmpty()) {
            return;
        }
        boolean hasSelf = false;
        if (function.isMethodDefinition() && (first = parameterList.all().get(0)).is(Tree.Kind.PARAMETER)) {
            this.currentScope().createSelfParameter((Parameter)first);
            hasSelf = true;
        }
        parameterList.nonTuple().stream().skip(hasSelf ? 1L : 0L).map(Parameter::name).filter(Objects::nonNull).forEach(param -> this.currentScope().addBindingUsage((Name)param, UsageV2.Kind.PARAMETER));
        parameterList.all().stream().filter(param -> param.is(Tree.Kind.TUPLE_PARAMETER)).map(TupleParameter.class::cast).forEach(this::addTupleParamElementsToBindingUsage);
    }

    private void addTupleParamElementsToBindingUsage(TupleParameter param) {
        param.parameters().stream().filter(p -> p.is(Tree.Kind.PARAMETER)).map(p -> ((Parameter)p).name()).forEach(name -> this.currentScope().addBindingUsage((Name)name, UsageV2.Kind.PARAMETER));
        param.parameters().stream().filter(p -> p.is(Tree.Kind.TUPLE_PARAMETER)).map(TupleParameter.class::cast).forEach(this::addTupleParamElementsToBindingUsage);
    }

    @Override
    public void visitTypeAliasStatement(TypeAliasStatement typeAliasStatement) {
        this.currentScope().addBindingUsage(typeAliasStatement.name(), UsageV2.Kind.TYPE_ALIAS_DECLARATION);
        super.visitTypeAliasStatement(typeAliasStatement);
    }

    @Override
    public void visitClassDef(ClassDef classDef) {
        this.currentScope().addBindingUsage(classDef.name(), UsageV2.Kind.CLASS_DECLARATION);
        this.createAndEnterScope(classDef, this.currentScope());
        this.createTypeParameters(classDef.typeParams());
        super.visitClassDef(classDef);
        this.leaveScope();
    }

    @Override
    public void visitImportName(ImportName importName) {
        this.createImportedNames(importName.modules(), null, Collections.emptyList());
        super.visitImportName(importName);
    }

    @Override
    public void visitImportFrom(ImportFrom importFrom) {
        String moduleName;
        DottedName moduleTree = importFrom.module();
        String string = moduleName = moduleTree != null ? moduleTree.names().stream().map(Name::name).collect(Collectors.joining(".")) : null;
        if (!importFrom.isWildcardImport()) {
            this.createImportedNames(importFrom.importedNames(), moduleName, importFrom.dottedPrefixForModule());
        }
        super.visitImportFrom(importFrom);
    }

    private void createImportedNames(List<AliasedName> importedNames, @Nullable String fromModuleName, List<Token> dottedPrefix) {
        importedNames.forEach(module -> {
            List<Name> dottedNames = module.dottedName().names();
            Name nameTree = dottedNames.get(0);
            String targetModuleName = fromModuleName;
            Name alias = module.alias();
            if (targetModuleName != null) {
                this.addBindingUsage(alias == null ? nameTree : alias, UsageV2.Kind.IMPORT);
            } else if (alias != null) {
                this.addBindingUsage(alias, UsageV2.Kind.IMPORT);
            } else if (dottedPrefix.isEmpty() && dottedNames.size() > 1) {
                this.addBindingUsage(nameTree, UsageV2.Kind.IMPORT);
            } else {
                this.addBindingUsage(nameTree, UsageV2.Kind.IMPORT);
            }
        });
    }

    @Override
    public void visitForStatement(ForStatement pyForStatementTree) {
        this.createLoopVariables(pyForStatementTree);
        super.visitForStatement(pyForStatementTree);
    }

    @Override
    public void visitComprehensionFor(ComprehensionFor tree) {
        this.addCompDeclarationParam(tree.loopExpression());
        super.visitComprehensionFor(tree);
    }

    private void addCompDeclarationParam(Tree tree) {
        SymbolUtils.boundNamesFromExpression(tree).forEach(name -> this.currentScope().addBindingUsage((Name)name, UsageV2.Kind.COMP_DECLARATION));
    }

    private void createLoopVariables(ForStatement loopTree) {
        loopTree.expressions().forEach(expr -> SymbolUtils.boundNamesFromExpression(expr).forEach(name -> this.currentScope().addBindingUsage((Name)name, UsageV2.Kind.LOOP_DECLARATION)));
    }

    @Override
    public void visitAssignmentStatement(AssignmentStatement pyAssignmentStatementTree) {
        SymbolUtils.assignmentsLhs(pyAssignmentStatementTree).stream().map(SymbolUtils::boundNamesFromExpression).flatMap(Collection::stream).forEach(name -> this.addBindingUsage((Name)name, UsageV2.Kind.ASSIGNMENT_LHS));
        super.visitAssignmentStatement(pyAssignmentStatementTree);
    }

    @Override
    public void visitAnnotatedAssignment(AnnotatedAssignment annotatedAssignment) {
        if (annotatedAssignment.variable().is(Tree.Kind.NAME)) {
            Name variable = (Name)annotatedAssignment.variable();
            this.addBindingUsage(variable, UsageV2.Kind.ASSIGNMENT_LHS);
        }
        super.visitAnnotatedAssignment(annotatedAssignment);
    }

    @Override
    public void visitCompoundAssignment(CompoundAssignmentStatement pyCompoundAssignmentStatementTree) {
        if (pyCompoundAssignmentStatementTree.lhsExpression().is(Tree.Kind.NAME)) {
            this.addBindingUsage((Name)pyCompoundAssignmentStatementTree.lhsExpression(), UsageV2.Kind.COMPOUND_ASSIGNMENT_LHS);
        }
        super.visitCompoundAssignment(pyCompoundAssignmentStatementTree);
    }

    @Override
    public void visitAssignmentExpression(AssignmentExpression assignmentExpression) {
        this.addBindingUsage(assignmentExpression.lhsName(), UsageV2.Kind.ASSIGNMENT_LHS);
        super.visitAssignmentExpression(assignmentExpression);
    }

    @Override
    public void visitGlobalStatement(GlobalStatement globalStatement) {
        globalStatement.variables().forEach(name -> {
            this.moduleScope.addBindingUsage((Name)name, UsageV2.Kind.GLOBAL_DECLARATION);
            this.currentScope().addGlobalName((Name)name);
        });
        super.visitGlobalStatement(globalStatement);
    }

    @Override
    public void visitNonlocalStatement(NonlocalStatement pyNonlocalStatementTree) {
        pyNonlocalStatementTree.variables().forEach(name -> this.currentScope().addNonLocalName((Name)name));
        super.visitNonlocalStatement(pyNonlocalStatementTree);
    }

    @Override
    public void visitExceptClause(ExceptClause exceptClause) {
        SymbolUtils.boundNamesFromExpression(exceptClause.exceptionInstance()).forEach(name -> this.addBindingUsage((Name)name, UsageV2.Kind.EXCEPTION_INSTANCE));
        super.visitExceptClause(exceptClause);
    }

    @Override
    public void visitWithItem(WithItem withItem) {
        SymbolUtils.boundNamesFromExpression(withItem.expression()).forEach(name -> this.addBindingUsage((Name)name, UsageV2.Kind.WITH_INSTANCE));
        super.visitWithItem(withItem);
    }

    @Override
    public void visitCapturePattern(CapturePattern capturePattern) {
        this.addBindingUsage(capturePattern.name(), UsageV2.Kind.PATTERN_DECLARATION);
        super.visitCapturePattern(capturePattern);
    }

    private void addBindingUsage(Name nameTree, UsageV2.Kind usage) {
        this.currentScope().addBindingUsage(nameTree, usage);
    }
}

