/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic.v2;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.cfg.ControlFlowGraph;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Parameter;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.v2.ModuleType;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.plugins.python.api.types.v2.TypeWrapper;
import org.sonar.plugins.python.api.types.v2.UnionType;
import org.sonar.python.semantic.SymbolUtils;
import org.sonar.python.semantic.v2.SymbolTable;
import org.sonar.python.semantic.v2.SymbolV2;
import org.sonar.python.semantic.v2.UsageV2;
import org.sonar.python.semantic.v2.types.AstBasedTypeInference;
import org.sonar.python.semantic.v2.types.FlowSensitiveTypeInference;
import org.sonar.python.semantic.v2.types.Propagation;
import org.sonar.python.semantic.v2.types.PropagationVisitor;
import org.sonar.python.semantic.v2.types.TrivialTypeInferenceVisitor;
import org.sonar.python.semantic.v2.types.TryStatementVisitor;
import org.sonar.python.semantic.v2.typetable.TypeTable;
import org.sonar.python.tree.TreeUtils;

public class TypeInferenceV2 {
    private final TypeTable projectLevelTypeTable;
    private final SymbolTable symbolTable;
    private final PythonFile pythonFile;
    private final String fullyQualifiedModuleName;
    private Set<String> importedModulesFQN;

    public TypeInferenceV2(TypeTable projectLevelTypeTable, PythonFile pythonFile, SymbolTable symbolTable, String packageName) {
        this.projectLevelTypeTable = projectLevelTypeTable;
        this.symbolTable = symbolTable;
        this.pythonFile = pythonFile;
        this.fullyQualifiedModuleName = SymbolUtils.fullyQualifiedModuleName(packageName, pythonFile.fileName());
    }

    public ModuleType inferModuleType(FileInput fileInput) {
        Map<SymbolV2, Set<PythonType>> typesBySymbols = this.inferTypes(fileInput);
        Map<String, TypeWrapper> members = typesBySymbols.entrySet().stream().map(entry -> {
            String memberName = ((SymbolV2)entry.getKey()).name();
            Set types = (Set)entry.getValue();
            PythonType type = UnionType.or(types);
            TypeWrapper typeWrapper = TypeWrapper.of(type);
            return Map.entry(memberName, typeWrapper);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        ModuleType parent = this.getParentModuleType();
        String[] fqnParts = this.fullyQualifiedModuleName.split("\\.");
        String name = fqnParts[fqnParts.length - 1];
        return new ModuleType(name, this.fullyQualifiedModuleName, parent, members);
    }

    @CheckForNull
    private ModuleType getParentModuleType() {
        ModuleType moduleType;
        List<String> fqnParts = List.of(this.fullyQualifiedModuleName.split("\\."));
        if (fqnParts.size() < 2) {
            return null;
        }
        List<String> parentFqnParts = fqnParts.subList(0, fqnParts.size() - 1);
        PythonType parent = this.projectLevelTypeTable.getModuleType(parentFqnParts);
        return parent instanceof ModuleType ? (moduleType = (ModuleType)parent) : null;
    }

    public Map<SymbolV2, Set<PythonType>> inferTypes(FileInput fileInput) {
        Map<SymbolV2, Set<PythonType>> result = this.inferTopLevelTypes(fileInput);
        fileInput.accept(new BaseTreeVisitor(){

            @Override
            public void visitFunctionDef(FunctionDef funcDef) {
                super.visitFunctionDef(funcDef);
                TypeInferenceV2.this.inferTypesAndMemberAccessSymbols(funcDef);
            }
        });
        return result;
    }

    public Map<SymbolV2, Set<PythonType>> inferTopLevelTypes(FileInput fileInput) {
        TrivialTypeInferenceVisitor trivialTypeInferenceVisitor = new TrivialTypeInferenceVisitor(this.projectLevelTypeTable, this.pythonFile, this.fullyQualifiedModuleName);
        this.importedModulesFQN = trivialTypeInferenceVisitor.importedModulesFQN();
        fileInput.accept(trivialTypeInferenceVisitor);
        return this.inferTypesAndMemberAccessSymbols(fileInput);
    }

    private Map<SymbolV2, Set<PythonType>> inferTypesAndMemberAccessSymbols(FileInput fileInput) {
        StatementList statements = fileInput.statements();
        if (statements == null) {
            return Map.of();
        }
        Set<SymbolV2> moduleSymbols = this.symbolTable.getSymbolsByRootTree(fileInput);
        return this.inferTypesAndMemberAccessSymbols(fileInput, statements, moduleSymbols, Collections.emptySet(), () -> ControlFlowGraph.build(fileInput, this.pythonFile));
    }

    private void inferTypesAndMemberAccessSymbols(FunctionDef functionDef) {
        Set<Name> parameterNames = TreeUtils.nonTupleParameters(functionDef).stream().map(Parameter::name).collect(Collectors.toSet());
        Set<SymbolV2> localVariables = this.symbolTable.getSymbolsByRootTree(functionDef);
        this.inferTypesAndMemberAccessSymbols(functionDef, functionDef.body(), localVariables, parameterNames, () -> ControlFlowGraph.build(functionDef, this.pythonFile));
    }

    private Map<SymbolV2, Set<PythonType>> inferTypesAndMemberAccessSymbols(Tree scopeTree, StatementList statements, Set<SymbolV2> declaredVariables, Set<Name> annotatedParameterNames, Supplier<ControlFlowGraph> controlFlowGraphSupplier) {
        PropagationVisitor propagationVisitor = new PropagationVisitor();
        scopeTree.accept(propagationVisitor);
        Set<Name> assignedNames = propagationVisitor.propagationsByLhs().values().stream().flatMap(Collection::stream).map(Propagation::lhsName).collect(Collectors.toSet());
        TryStatementVisitor tryStatementVisitor = new TryStatementVisitor();
        statements.accept(tryStatementVisitor);
        if (tryStatementVisitor.hasTryStatement()) {
            return new AstBasedTypeInference(propagationVisitor.propagationsByLhs(), this.projectLevelTypeTable).process(TypeInferenceV2.getTrackedVars(declaredVariables, assignedNames));
        }
        ControlFlowGraph cfg = controlFlowGraphSupplier.get();
        if (cfg == null) {
            return Map.of();
        }
        assignedNames.addAll(annotatedParameterNames);
        return this.flowSensitiveTypeInference(cfg, TypeInferenceV2.getTrackedVars(declaredVariables, assignedNames), propagationVisitor);
    }

    private Map<SymbolV2, Set<PythonType>> flowSensitiveTypeInference(ControlFlowGraph cfg, Set<SymbolV2> trackedVars, PropagationVisitor propagationVisitor) {
        Map<String, PythonType> parameterTypes = trackedVars.stream().filter(symbol -> symbol.usages().stream().anyMatch(usage -> usage.kind() == UsageV2.Kind.PARAMETER)).collect(Collectors.toMap(SymbolV2::name, TypeInferenceV2::getParameterType));
        FlowSensitiveTypeInference flowSensitiveTypeInference = new FlowSensitiveTypeInference(this.projectLevelTypeTable, trackedVars, propagationVisitor.assignmentsByAssignmentStatement(), propagationVisitor.definitionsByDefinitionStatement(), parameterTypes);
        flowSensitiveTypeInference.compute(cfg);
        return flowSensitiveTypeInference.compute(cfg).typesBySymbol();
    }

    private static PythonType getParameterType(SymbolV2 symbol) {
        return symbol.usages().stream().filter(usage -> usage.kind() == UsageV2.Kind.PARAMETER).map(UsageV2::tree).filter(Expression.class::isInstance).map(Expression.class::cast).map(Expression::typeV2).findFirst().orElse(PythonType.UNKNOWN);
    }

    private static Set<SymbolV2> getTrackedVars(Set<SymbolV2> localVariables, Set<Name> assignedNames) {
        HashSet<SymbolV2> trackedVars = new HashSet<SymbolV2>();
        for (SymbolV2 variable : localVariables) {
            boolean hasMissingBindingUsage = variable.usages().stream().filter(UsageV2::isBindingUsage).anyMatch(u -> !assignedNames.contains(u.tree()));
            boolean isGlobalOrNonLocal = variable.usages().stream().anyMatch(v -> v.kind().equals((Object)UsageV2.Kind.GLOBAL_DECLARATION) || v.kind().equals((Object)UsageV2.Kind.NONLOCAL_DECLARATION));
            if (hasMissingBindingUsage || isGlobalOrNonLocal) continue;
            trackedVars.add(variable);
        }
        return trackedVars;
    }

    public Set<String> importedModulesFQN() {
        return this.importedModulesFQN;
    }
}

