/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic.v2;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.plugins.python.api.types.v2.ModuleType;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.plugins.python.api.types.v2.TypeOrigin;
import org.sonar.plugins.python.api.types.v2.TypeWrapper;
import org.sonar.python.index.Descriptor;
import org.sonar.python.semantic.ProjectLevelSymbolTable;
import org.sonar.python.semantic.v2.LazyTypesContext;
import org.sonar.python.semantic.v2.converter.AnyDescriptorToPythonTypeConverter;

public class SymbolsModuleTypeProvider {
    private final ProjectLevelSymbolTable projectLevelSymbolTable;
    private final ModuleType rootModule;
    private final LazyTypesContext lazyTypesContext;
    private final AnyDescriptorToPythonTypeConverter anyDescriptorToPythonTypeConverter;
    private final Map<String, Map<String, String>> aliasMembers = Map.ofEntries(Map.entry("typing", Map.ofEntries(Map.entry("List", "list"), Map.entry("Tuple", "tuple"), Map.entry("Dict", "dict"), Map.entry("Set", "set"), Map.entry("FrozenSet", "frozenset"), Map.entry("Type", "type"))));

    public SymbolsModuleTypeProvider(ProjectLevelSymbolTable projectLevelSymbolTable, LazyTypesContext lazyTypeContext) {
        this.projectLevelSymbolTable = projectLevelSymbolTable;
        this.lazyTypesContext = lazyTypeContext;
        this.anyDescriptorToPythonTypeConverter = new AnyDescriptorToPythonTypeConverter(this.lazyTypesContext);
        Map<String, TypeWrapper> rootModuleMembers = projectLevelSymbolTable.typeShedDescriptorsProvider().builtinDescriptors().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> TypeWrapper.of(this.anyDescriptorToPythonTypeConverter.convert("", (Descriptor)e.getValue(), TypeOrigin.STUB))));
        this.rootModule = new ModuleType(null, null, null, rootModuleMembers);
    }

    public ModuleType getRootModule() {
        return this.rootModule;
    }

    public PythonType convertModuleType(List<String> moduleFqn, ModuleType parent) {
        String moduleFqnString;
        String moduleName = moduleFqn.get(moduleFqn.size() - 1);
        Optional<ModuleType> result = this.createModuleTypeFromProjectLevelSymbolTable(moduleName, moduleFqnString = SymbolsModuleTypeProvider.getModuleFqnString(moduleFqn), parent).or(() -> this.createModuleTypeFromTypeShed(moduleName, moduleFqnString, parent));
        if (result.isEmpty()) {
            return PythonType.UNKNOWN;
        }
        return result.get();
    }

    private static String getModuleFqnString(List<String> moduleFqn) {
        return String.join((CharSequence)".", moduleFqn);
    }

    private Optional<ModuleType> createModuleTypeFromProjectLevelSymbolTable(String moduleName, String moduleFqn, ModuleType parent) {
        Set<Descriptor> retrieved = this.projectLevelSymbolTable.getDescriptorsFromModule(moduleFqn);
        if (retrieved == null) {
            return Optional.empty();
        }
        Map<String, TypeWrapper> members = retrieved.stream().collect(Collectors.toMap(Descriptor::name, d -> TypeWrapper.of(this.anyDescriptorToPythonTypeConverter.convert(moduleFqn, (Descriptor)d, TypeOrigin.LOCAL))));
        return Optional.of(this.createModuleType(moduleName, moduleFqn, parent, members));
    }

    private Optional<ModuleType> createModuleTypeFromTypeShed(String moduleName, String moduleFqn, ModuleType parent) {
        Map<String, Descriptor> stringDescriptorMap = this.projectLevelSymbolTable.typeShedDescriptorsProvider().descriptorsForModule(moduleFqn);
        Map<String, TypeWrapper> members = this.anyDescriptorToPythonTypeConverter.convertModuleType(moduleFqn, stringDescriptorMap);
        return Optional.of(members).filter(m -> !m.isEmpty()).map(m -> this.createModuleType(moduleName, moduleFqn, parent, (Map<String, TypeWrapper>)m));
    }

    private ModuleType createModuleType(String moduleName, String moduleFqn, ModuleType parent, Map<String, TypeWrapper> members) {
        this.addTypingAliases(moduleFqn, members);
        return new ModuleType(moduleName, moduleFqn, parent, members);
    }

    private void addTypingAliases(String moduleFqn, Map<String, TypeWrapper> members) {
        this.aliasMembers.getOrDefault(moduleFqn, Map.of()).forEach((alias, original) -> {
            TypeWrapper originalType = this.rootModule.members().get(original);
            if (originalType != null) {
                members.put((String)alias, originalType);
            }
        });
    }
}

