/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic.v2;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.sonar.api.Beta;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.python.semantic.v2.UsageV2;
import org.sonar.python.tree.NameImpl;

@Beta
public class SymbolV2 {
    private final String name;
    private final List<UsageV2> usages;

    public SymbolV2(String name, List<UsageV2> usages) {
        this.name = name;
        this.usages = usages;
    }

    public SymbolV2(String name) {
        this(name, new ArrayList<UsageV2>());
    }

    void addUsage(Name name, UsageV2.Kind kind) {
        UsageV2 usage = new UsageV2(name, kind);
        this.usages.add(usage);
        if (name instanceof NameImpl) {
            NameImpl ni = (NameImpl)name;
            ni.symbolV2(this);
        }
    }

    @Beta
    public boolean hasSingleBindingUsage() {
        return this.getSingleBindingUsage().isPresent();
    }

    @Beta
    public Optional<UsageV2> getSingleBindingUsage() {
        List<UsageV2> bindingUsages = this.usages().stream().filter(UsageV2::isBindingUsage).toList();
        if (bindingUsages.size() == 1) {
            return Optional.of(bindingUsages.get(0));
        }
        return Optional.empty();
    }

    public String name() {
        return this.name;
    }

    public List<UsageV2> usages() {
        return this.usages;
    }
}

