/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic.v2;

import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.semantic.v2.ScopeV2;

public class ScopeVisitor
extends BaseTreeVisitor {
    private final Map<Tree, ScopeV2> scopesByRootTree;
    private final Deque<Tree> scopeRootTrees;

    public ScopeVisitor(Map<Tree, ScopeV2> scopesByRootTree) {
        this.scopesByRootTree = scopesByRootTree;
        this.scopeRootTrees = new LinkedList<Tree>();
    }

    Tree currentScopeRootTree() {
        return this.scopeRootTrees.peek();
    }

    void enterScope(Tree tree) {
        this.scopeRootTrees.push(tree);
    }

    Tree leaveScope() {
        return this.scopeRootTrees.pop();
    }

    ScopeV2 currentScope() {
        return this.scopesByRootTree.get(this.currentScopeRootTree());
    }

    void createScope(Tree tree, @Nullable ScopeV2 parent) {
        this.scopesByRootTree.put(tree, new ScopeV2(parent, tree));
    }

    void createAndEnterScope(Tree tree, @Nullable ScopeV2 parent) {
        this.createScope(tree, parent);
        this.enterScope(tree);
    }
}

