/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic.v2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Parameter;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.semantic.v2.SymbolV2;
import org.sonar.python.semantic.v2.UsageV2;

public class ScopeV2 {
    private final ScopeV2 parent;
    private final Tree rootTree;
    private final List<ScopeV2> childrenScopes;
    private final Map<String, SymbolV2> symbolsByName = new HashMap<String, SymbolV2>();
    private final Set<SymbolV2> symbols = new HashSet<SymbolV2>();
    private final Set<String> globalNames = new HashSet<String>();
    private final Set<String> nonlocalNames = new HashSet<String>();

    public ScopeV2(@Nullable ScopeV2 parent, Tree rootTree) {
        this.parent = parent;
        this.rootTree = rootTree;
        this.childrenScopes = new ArrayList<ScopeV2>();
    }

    public ScopeV2 parent() {
        return this.parent;
    }

    public Tree root() {
        return this.rootTree;
    }

    void addBindingUsage(Name nameTree, UsageV2.Kind kind) {
        SymbolV2 symbol;
        String symbolName = nameTree.name();
        if (!this.isExistingSymbol(symbolName)) {
            symbol = new SymbolV2(symbolName);
            this.symbols.add(symbol);
            this.symbolsByName.put(symbolName, symbol);
        }
        if ((symbol = this.resolve(symbolName)) != null) {
            symbol.addUsage(nameTree, kind);
        }
    }

    @CheckForNull
    SymbolV2 resolve(String symbolName) {
        SymbolV2 symbol = this.symbolsByName.get(symbolName);
        if (this.parent == null || symbol != null) {
            return symbol;
        }
        if (this.parent.rootTree.is(Tree.Kind.CLASSDEF)) {
            return this.parent.parent.resolve(symbolName);
        }
        return this.parent.resolve(symbolName);
    }

    private boolean isExistingSymbol(String symbolName) {
        return this.symbolsByName.containsKey(symbolName) || this.globalNames.contains(symbolName) || this.nonlocalNames.contains(symbolName);
    }

    void createSelfParameter(Parameter parameter) {
        Name nameTree = parameter.name();
        if (nameTree == null) {
            return;
        }
        String symbolName = nameTree.name();
        SymbolV2 symbol = new SymbolV2(symbolName);
        this.symbols.add(symbol);
        this.symbolsByName.put(symbolName, symbol);
        symbol.addUsage(nameTree, UsageV2.Kind.PARAMETER);
    }

    public void addGlobalName(Name name) {
        this.globalNames.add(name.name());
    }

    public void addNonLocalName(Name name) {
        this.nonlocalNames.add(name.name());
    }

    public Map<String, SymbolV2> symbols() {
        return this.symbolsByName;
    }

    public List<ScopeV2> childrenScopes() {
        return this.childrenScopes;
    }
}

