/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic.v2;

import java.util.Map;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.ComprehensionExpression;
import org.sonar.plugins.python.api.tree.ComprehensionFor;
import org.sonar.plugins.python.api.tree.DictCompExpression;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.LambdaExpression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Parameter;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TypeAnnotation;
import org.sonar.python.semantic.v2.ScopeV2;
import org.sonar.python.semantic.v2.ScopeVisitor;
import org.sonar.python.semantic.v2.SymbolV2;
import org.sonar.python.semantic.v2.UsageV2;

public class ReadUsagesVisitor
extends ScopeVisitor {
    public ReadUsagesVisitor(Map<Tree, ScopeV2> scopesByRootTree) {
        super(scopesByRootTree);
    }

    @Override
    public void visitFileInput(FileInput tree) {
        this.enterScope(tree);
        super.visitFileInput(tree);
    }

    @Override
    public void visitFunctionDef(FunctionDef pyFunctionDefTree) {
        this.scan(pyFunctionDefTree.decorators());
        this.enterScope(pyFunctionDefTree);
        this.scan(pyFunctionDefTree.name());
        this.scan(pyFunctionDefTree.typeParams());
        this.scan(pyFunctionDefTree.parameters());
        this.scan(pyFunctionDefTree.returnTypeAnnotation());
        this.scan(pyFunctionDefTree.body());
        this.leaveScope();
    }

    @Override
    public void visitParameter(Parameter parameter) {
        Tree currentScopeTree = this.leaveScope();
        this.scan(parameter.defaultValue());
        this.enterScope(currentScopeTree);
        this.scan(parameter.name());
        this.scan(parameter.typeAnnotation());
    }

    @Override
    public void visitLambda(LambdaExpression pyLambdaExpressionTree) {
        this.enterScope(pyLambdaExpressionTree);
        super.visitLambda(pyLambdaExpressionTree);
        this.leaveScope();
    }

    @Override
    public void visitPyListOrSetCompExpression(ComprehensionExpression tree) {
        this.enterScope(tree);
        this.scan(tree.resultExpression());
        ComprehensionFor comprehensionFor = tree.comprehensionFor();
        this.scan(comprehensionFor.loopExpression());
        this.leaveScope();
        this.scan(comprehensionFor.iterable());
        this.enterScope(tree);
        this.scan(comprehensionFor.nestedClause());
        this.leaveScope();
    }

    @Override
    public void visitDictCompExpression(DictCompExpression tree) {
        this.enterScope(tree);
        this.scan(tree.keyExpression());
        this.scan(tree.valueExpression());
        ComprehensionFor comprehensionFor = tree.comprehensionFor();
        this.scan(comprehensionFor.loopExpression());
        this.leaveScope();
        this.scan(comprehensionFor.iterable());
        this.enterScope(tree);
        this.scan(comprehensionFor.nestedClause());
        this.leaveScope();
    }

    @Override
    public void visitTypeAnnotation(TypeAnnotation tree) {
        if (tree.is(Tree.Kind.PARAMETER_TYPE_ANNOTATION) || tree.is(Tree.Kind.RETURN_TYPE_ANNOTATION)) {
            Tree currentScopeTree = this.leaveScope();
            super.visitTypeAnnotation(tree);
            this.enterScope(currentScopeTree);
            super.visitTypeAnnotation(tree);
        } else {
            super.visitTypeAnnotation(tree);
        }
    }

    @Override
    public void visitClassDef(ClassDef classDef) {
        this.scan(classDef.args());
        this.scan(classDef.decorators());
        this.enterScope(classDef);
        this.scan(classDef.name());
        this.scan(classDef.body());
        this.leaveScope();
    }

    @Override
    public void visitName(Name name) {
        if (!name.isVariable()) {
            return;
        }
        this.addSymbolUsage(name);
        super.visitName(name);
    }

    private void addSymbolUsage(Name name) {
        ScopeV2 scope = this.currentScope();
        SymbolV2 symbol = scope.resolve(name.name());
        if (symbol != null && symbol.usages().stream().noneMatch(usage -> usage.tree().equals(name))) {
            if (name.parent().is(Tree.Kind.GLOBAL_STMT)) {
                symbol.addUsage(name, UsageV2.Kind.GLOBAL_DECLARATION);
            } else if (name.parent().is(Tree.Kind.NONLOCAL_STMT)) {
                symbol.addUsage(name, UsageV2.Kind.NONLOCAL_DECLARATION);
            } else {
                symbol.addUsage(name, UsageV2.Kind.OTHER);
            }
        }
    }
}

