/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic.v2;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.plugins.python.api.types.v2.TypeWrapper;
import org.sonar.python.semantic.v2.typetable.ProjectLevelTypeTable;
import org.sonar.python.semantic.v2.typetable.TypeTable;
import org.sonar.python.types.v2.LazyType;
import org.sonar.python.types.v2.LazyTypeWrapper;

public class LazyTypesContext {
    private final Map<String, LazyType> lazyTypes = new ConcurrentHashMap<String, LazyType>();
    private final TypeTable typeTable;

    public LazyTypesContext(ProjectLevelTypeTable typeTable) {
        this.typeTable = typeTable;
    }

    public TypeWrapper getOrCreateLazyTypeWrapper(String importPath) {
        return new LazyTypeWrapper(this.getOrCreateLazyType(importPath));
    }

    public LazyType getOrCreateLazyType(String importPath) {
        return this.lazyTypes.computeIfAbsent(importPath, ip -> new LazyType((String)ip, this));
    }

    public PythonType resolveLazyType(LazyType lazyType) {
        PythonType resolved = this.typeTable.getType(lazyType.importPath());
        lazyType.resolve(resolved);
        this.lazyTypes.remove(lazyType.importPath());
        return resolved;
    }
}

