/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic.v2;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.LocationInFile;
import org.sonar.plugins.python.api.tree.AnyParameter;
import org.sonar.plugins.python.api.tree.Decorator;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Parameter;
import org.sonar.plugins.python.api.tree.ParameterList;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.v2.FunctionType;
import org.sonar.plugins.python.api.types.v2.ParameterV2;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.plugins.python.api.types.v2.TypeOrigin;
import org.sonar.plugins.python.api.types.v2.TypeWrapper;
import org.sonar.python.semantic.v2.TypeBuilder;
import org.sonar.python.semantic.v2.typetable.TypeTable;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.SimpleTypeWrapper;

public class FunctionTypeBuilder
implements TypeBuilder<FunctionType> {
    private boolean hasVariadicParameter;
    private String name;
    private String fullyQualifiedName;
    private List<PythonType> attributes;
    private List<ParameterV2> parameters;
    private List<TypeWrapper> decorators;
    private boolean isAsynchronous;
    private boolean hasDecorators;
    private boolean isInstanceMethod;
    private PythonType owner;
    private TypeWrapper returnType = TypeWrapper.UNKNOWN_TYPE_WRAPPER;
    private TypeOrigin typeOrigin = TypeOrigin.STUB;
    private LocationInFile definitionLocation;
    private static final String CLASS_METHOD_DECORATOR = "classmethod";
    private static final String STATIC_METHOD_DECORATOR = "staticmethod";

    public FunctionTypeBuilder fromFunctionDef(FunctionDef functionDef, String fullyQualifiedName, @Nullable String fileId, TypeTable projectLevelTypeTable) {
        this.name = functionDef.name().name();
        this.fullyQualifiedName = fullyQualifiedName;
        this.attributes = new ArrayList<PythonType>();
        this.parameters = new ArrayList<ParameterV2>();
        this.isAsynchronous = functionDef.asyncKeyword() != null;
        this.hasDecorators = !functionDef.decorators().isEmpty();
        this.decorators = functionDef.decorators().stream().map(Decorator::expression).map(Expression::typeV2).map(TypeWrapper::of).toList();
        this.isInstanceMethod = FunctionTypeBuilder.isInstanceMethod(functionDef);
        ParameterList parameterList = functionDef.parameters();
        if (parameterList != null) {
            this.createParameterNames(parameterList.all(), fileId, projectLevelTypeTable);
        }
        return this;
    }

    public FunctionTypeBuilder(String name) {
        this.name = name;
    }

    public FunctionTypeBuilder() {
    }

    public FunctionTypeBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public FunctionTypeBuilder withFullyQualifiedName(@Nullable String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
        return this;
    }

    public FunctionTypeBuilder withHasVariadicParameter(boolean hasVariadicParameter) {
        this.hasVariadicParameter = hasVariadicParameter;
        return this;
    }

    public FunctionTypeBuilder withAttributes(List<PythonType> attributes) {
        this.attributes = attributes;
        return this;
    }

    public FunctionTypeBuilder withParameters(List<ParameterV2> parameters) {
        this.parameters = parameters;
        return this;
    }

    public FunctionTypeBuilder withDecorators(List<TypeWrapper> decorators) {
        this.decorators = decorators;
        return this;
    }

    public FunctionTypeBuilder withAsynchronous(boolean asynchronous) {
        this.isAsynchronous = asynchronous;
        return this;
    }

    public FunctionTypeBuilder withHasDecorators(boolean hasDecorators) {
        this.hasDecorators = hasDecorators;
        return this;
    }

    public FunctionTypeBuilder withInstanceMethod(boolean instanceMethod) {
        this.isInstanceMethod = instanceMethod;
        return this;
    }

    public FunctionTypeBuilder withReturnType(PythonType returnType) {
        this.withReturnType(TypeWrapper.of(returnType));
        return this;
    }

    public FunctionTypeBuilder withReturnType(TypeWrapper returnType) {
        this.returnType = returnType;
        return this;
    }

    public FunctionTypeBuilder withTypeOrigin(TypeOrigin typeOrigin) {
        this.typeOrigin = typeOrigin;
        return this;
    }

    public FunctionTypeBuilder withDefinitionLocation(@Nullable LocationInFile definitionLocation) {
        this.definitionLocation = definitionLocation;
        return this;
    }

    @Override
    public FunctionType build() {
        return new FunctionType(this.name, this.fullyQualifiedName, this.attributes, this.parameters, this.decorators, this.returnType, this.typeOrigin, this.isAsynchronous, this.hasDecorators, this.isInstanceMethod, this.hasVariadicParameter, this.owner, this.definitionLocation);
    }

    private static boolean isInstanceMethod(FunctionDef functionDef) {
        return !"__new__".equals(functionDef.name().name()) && functionDef.isMethodDefinition() && functionDef.decorators().stream().map(decorator -> TreeUtils.decoratorNameFromExpression(decorator.expression())).filter(Objects::nonNull).noneMatch(decorator -> decorator.equals(STATIC_METHOD_DECORATOR) || decorator.equals(CLASS_METHOD_DECORATOR));
    }

    public FunctionTypeBuilder withOwner(PythonType owner) {
        this.owner = owner;
        return this;
    }

    private void createParameterNames(List<AnyParameter> parameterTrees, @Nullable String fileId, TypeTable projectLevelTypeTable) {
        ParameterState parameterState = new ParameterState();
        parameterState.positionalOnly = parameterTrees.stream().anyMatch(param -> Optional.of(param).filter(p -> p.is(Tree.Kind.PARAMETER)).map(p -> ((Parameter)p).starToken()).map(Token::value).filter("/"::equals).isPresent());
        for (AnyParameter anyParameter : parameterTrees) {
            if (anyParameter.is(Tree.Kind.PARAMETER)) {
                this.addParameter((Parameter)anyParameter, fileId, parameterState, projectLevelTypeTable);
                continue;
            }
            this.parameters.add(new ParameterV2(null, new SimpleTypeWrapper(PythonType.UNKNOWN), false, parameterState.keywordOnly, parameterState.positionalOnly, false, false, TreeUtils.locationInFile(anyParameter, fileId)));
        }
    }

    private void addParameter(Parameter parameter, @Nullable String fileId, ParameterState parameterState, TypeTable projectLevelTypeTable) {
        Name parameterName = parameter.name();
        Token starToken = parameter.starToken();
        if (parameterName != null) {
            ParameterType parameterType = this.getParameterType(parameter, projectLevelTypeTable);
            this.parameters.add(new ParameterV2(parameterName.name(), TypeWrapper.of(parameterType.pythonType()), parameter.defaultValue() != null, parameterState.keywordOnly, parameterState.positionalOnly, parameterType.isKeywordVariadic(), parameterType.isPositionalVariadic(), TreeUtils.locationInFile(parameter, fileId)));
            if (starToken != null) {
                this.hasVariadicParameter = true;
                parameterState.keywordOnly = true;
                parameterState.positionalOnly = false;
            }
        } else if (starToken != null) {
            if ("*".equals(starToken.value())) {
                parameterState.keywordOnly = true;
                parameterState.positionalOnly = false;
            }
            if ("/".equals(starToken.value())) {
                parameterState.positionalOnly = false;
            }
        }
    }

    private ParameterType getParameterType(Parameter parameter, TypeTable projectLevelTypeTable) {
        boolean isPositionalVariadic = false;
        boolean isKeywordVariadic = false;
        Token starToken = parameter.starToken();
        PythonType parameterType = Optional.ofNullable(parameter.name()).map(Expression::typeV2).orElse(PythonType.UNKNOWN);
        if (starToken != null) {
            this.hasVariadicParameter = true;
            if ("*".equals(starToken.value())) {
                isPositionalVariadic = true;
                parameterType = projectLevelTypeTable.getBuiltinsModule().resolveMember("tuple").orElse(PythonType.UNKNOWN);
            }
            if ("**".equals(starToken.value())) {
                isKeywordVariadic = true;
                parameterType = projectLevelTypeTable.getBuiltinsModule().resolveMember("dict").orElse(PythonType.UNKNOWN);
            }
        }
        return new ParameterType(parameterType, isKeywordVariadic, isPositionalVariadic);
    }

    public static class ParameterState {
        boolean keywordOnly = false;
        boolean positionalOnly = false;
    }

    record ParameterType(PythonType pythonType, boolean isKeywordVariadic, boolean isPositionalVariadic) {
    }
}

